/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.network;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.core.content.ContextCompat;
import com.kaspersky.components.kautomator.system.UiSystem;
import com.kaspersky.kaspresso.device.network.Network;
import com.kaspersky.kaspresso.device.network.NetworkImpl;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.flakysafety.algorithm.FlakySafetyAlgorithm;
import com.kaspersky.kaspresso.internal.exceptions.AdbServerException;
import com.kaspersky.kaspresso.internal.systemscreen.DataUsageSettingsScreen;
import com.kaspersky.kaspresso.internal.systemscreen.NotificationsFullScreen;
import com.kaspersky.kaspresso.internal.systemscreen.NotificationsMobileDataScreen;
import com.kaspersky.kaspresso.internal.systemscreen.NotificationsShortScreen;
import com.kaspersky.kaspresso.internal.systemscreen.WiFiSettingsScreen;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.FlakySafetyParams;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/kaspersky/kaspresso/device/network/NetworkImpl;", "Lcom/kaspersky/kaspresso/device/network/Network;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "targetContext", "Landroid/content/Context;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Landroid/content/Context;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "currentOsVersion", "", "flakySafetyAlgorithm", "Lcom/kaspersky/kaspresso/flakysafety/algorithm/FlakySafetyAlgorithm;", "flakySafetyParams", "Lcom/kaspersky/kaspresso/params/FlakySafetyParams;", "getFlakySafetyParams", "()Lcom/kaspersky/kaspresso/params/FlakySafetyParams;", "changeWiFiStateUsingAdbServer", "", "isEnabled", "changeCommand", "", "changeWiFiStateUsingAndroidApi", "changeWifiStateUsingAndroidSettings", "", "disable", "enable", "parseAdbResponse", "response", "", "toggleMobileData", "toggleMobileDataUsingAdbServer", "toggleMobileDataUsingAndroidSettings", "toggleMobileDataUsingAndroidSettingsOnHighAndroid", "toggleMobileDataUsingAndroidSettingsOnLowAndroid", "toggleWiFi", "Companion", "kaspresso_release"})
public final class NetworkImpl
implements Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Context targetContext;
    @NotNull
    private final AdbServer adbServer;
    @NotNull
    private final FlakySafetyAlgorithm flakySafetyAlgorithm;
    private final int currentOsVersion;
    @NotNull
    private static final String CMD_STATE_ENABLE = "enable";
    @NotNull
    private static final String CMD_STATE_DISABLE = "disable";
    @NotNull
    private static final String NETWORK_STATE_CHANGE_CMD = "svc data";
    @NotNull
    private static final String NETWORK_STATE_CHANGE_ROOT_CMD = "su 0 svc data";
    @NotNull
    private static final String NETWORK_STATE_CHECK_CMD = "settings get global mobile_data";
    @NotNull
    private static final String NETWORK_STATE_CHECK_RESULT_ENABLED = "1";
    @NotNull
    private static final String NETWORK_STATE_CHECK_RESULT_DISABLED = "0";
    @NotNull
    private static final String WIFI_STATE_CHANGE_CMD = "svc wifi";
    @NotNull
    private static final String WIFI_STATE_CHANGE_ROOT_CMD = "su 0 svc wifi";
    @NotNull
    private static final String WIFI_STATE_CHECK_CMD = "settings get global wifi_on";
    @NotNull
    private static final String WIFI_STATE_CHECK_RESULT_ENABLED = "1";
    @NotNull
    private static final String WIFI_STATE_CHECK_RESULT_DISABLED = "0";
    @NotNull
    private static final Regex ADB_RESULT_REGEX = new Regex("exitCode=(\\d+), message=(.+)");

    public NetworkImpl(@NotNull UiTestLogger logger, @NotNull Context targetContext, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)targetContext, (String)"targetContext");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.targetContext = targetContext;
        this.adbServer = adbServer;
        this.flakySafetyAlgorithm = new FlakySafetyAlgorithm(this.logger);
        this.currentOsVersion = Build.VERSION.SDK_INT;
    }

    private final FlakySafetyParams getFlakySafetyParams() {
        return new FlakySafetyParams(1000L, 100L, SetsKt.setOf(AdbServerException.class));
    }

    @Override
    public void enable() {
        this.toggleMobileData(true);
        this.toggleWiFi(true);
        this.logger.i("Enable wi-fi and mobile data");
    }

    @Override
    public void disable() {
        this.toggleMobileData(false);
        this.toggleWiFi(false);
        this.logger.i("Disable wi-fi and mobile data");
    }

    @Override
    public void toggleMobileData(boolean enable) {
        if (!this.toggleMobileDataUsingAdbServer(enable, NETWORK_STATE_CHANGE_ROOT_CMD) && !this.toggleMobileDataUsingAdbServer(enable, NETWORK_STATE_CHANGE_CMD)) {
            this.toggleMobileDataUsingAndroidSettings(enable);
            this.logger.i("Mobile data " + (enable ? "en" : "dis") + "abled");
        }
    }

    private final boolean toggleMobileDataUsingAdbServer(boolean enable, String changeCommand) {
        boolean bl;
        try {
            Pair pair;
            boolean bl2 = enable;
            if (bl2) {
                pair = TuplesKt.to((Object)CMD_STATE_ENABLE, (Object)"1");
            } else if (!bl2) {
                pair = TuplesKt.to((Object)CMD_STATE_DISABLE, (Object)"0");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            String state = (String)pair2.component1();
            String expectedResult = (String)pair2.component2();
            String[] stringArray = new String[]{changeCommand + ' ' + state};
            this.adbServer.performShell(stringArray);
            bl = (Boolean)FlakySafetyAlgorithm.invokeFlakySafely$default(this.flakySafetyAlgorithm, this.getFlakySafetyParams(), null, (Function0)new Function0<Boolean>(this, expectedResult){
                final /* synthetic */ NetworkImpl this$0;
                final /* synthetic */ String $expectedResult;
                {
                    this.this$0 = $receiver;
                    this.$expectedResult = $expectedResult;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    String string;
                    Object object = new String[]{"settings get global mobile_data"};
                    List<String> result = NetworkImpl.access$getAdbServer$p(this.this$0).performShell((String)object);
                    object = NetworkImpl.access$parseAdbResponse(this.this$0, result);
                    if (object == null) {
                        string = null;
                    } else {
                        Object object2 = object;
                        boolean bl = false;
                        string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
                    }
                    if (!Intrinsics.areEqual(string, (Object)this.$expectedResult)) {
                        throw new AdbServerException("Failed to change network state using ABD");
                    }
                    return true;
                }
            }, 2, null);
        }
        catch (AdbServerException ex) {
            bl = false;
        }
        return bl;
    }

    private final void toggleMobileDataUsingAndroidSettings(boolean enable) {
        if (this.currentOsVersion < 24) {
            this.toggleMobileDataUsingAndroidSettingsOnLowAndroid(enable);
        } else {
            this.toggleMobileDataUsingAndroidSettingsOnHighAndroid(enable);
        }
    }

    private final void toggleMobileDataUsingAndroidSettingsOnHighAndroid(boolean enable) {
        DataUsageSettingsScreen.INSTANCE.invoke((Function1)new Function1<DataUsageSettingsScreen, Unit>(this, enable){
            final /* synthetic */ NetworkImpl this$0;
            final /* synthetic */ boolean $enable;
            {
                this.this$0 = $receiver;
                this.$enable = $enable;
                super(1);
            }

            public final void invoke(@NotNull DataUsageSettingsScreen $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$invoke), (String)"$this$invoke");
                $this$invoke.open(NetworkImpl.access$getTargetContext$p(this.this$0));
                boolean bl = this.$enable;
                if (bl) {
                    $this$invoke.enableMobileData();
                } else if (!bl) {
                    $this$invoke.disableMobileData();
                }
                $this$invoke.close(NetworkImpl.access$getTargetContext$p(this.this$0));
            }
        });
    }

    private final void toggleMobileDataUsingAndroidSettingsOnLowAndroid(boolean enable) {
        int height = this.targetContext.getResources().getDisplayMetrics().heightPixels;
        int width = this.targetContext.getResources().getDisplayMetrics().widthPixels;
        UiSystem.INSTANCE.invoke((Function1)new Function1<UiSystem, Unit>(width, height){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull UiSystem $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.drag(this.$width / 2, 0, this.$width / 2, (int)((double)this.$height * 0.67), 50);
            }
        });
        NotificationsShortScreen.INSTANCE.invoke(toggleMobileDataUsingAndroidSettingsOnLowAndroid.2.INSTANCE);
        NotificationsFullScreen.INSTANCE.invoke(toggleMobileDataUsingAndroidSettingsOnLowAndroid.3.INSTANCE);
        NotificationsMobileDataScreen.INSTANCE.invoke((Function1)new Function1<NotificationsMobileDataScreen, Unit>(enable){
            final /* synthetic */ boolean $enable;
            {
                this.$enable = $enable;
                super(1);
            }

            public final void invoke(@NotNull NotificationsMobileDataScreen $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$invoke), (String)"$this$invoke");
                boolean bl = this.$enable;
                if (bl) {
                    $this$invoke.getMobileDataSwitch().setChecked(true);
                } else if (!bl) {
                    $this$invoke.getMobileDataSwitch().setChecked(false);
                }
            }
        });
        UiSystem.INSTANCE.invoke((Function1)new Function1<UiSystem, Unit>(width, height){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull UiSystem $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.drag(this.$width / 2, this.$height, this.$width / 2, 0, 50);
            }
        });
    }

    @Override
    public void toggleWiFi(boolean enable) {
        if (!(this.changeWiFiStateUsingAndroidApi(enable) || this.changeWiFiStateUsingAdbServer(enable, WIFI_STATE_CHANGE_ROOT_CMD) || this.changeWiFiStateUsingAdbServer(enable, WIFI_STATE_CHANGE_CMD))) {
            this.changeWifiStateUsingAndroidSettings(enable);
            this.logger.i("Wi-fi " + (enable ? "en" : "dis") + "abled");
        }
    }

    private final boolean changeWiFiStateUsingAndroidApi(boolean isEnabled) {
        int targetSdkVersion = this.targetContext.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion >= 29) {
            return false;
        }
        if (ContextCompat.checkSelfPermission((Context)this.targetContext, (String)"android.permission.CHANGE_WIFI_STATE") == -1) {
            return false;
        }
        Object object = this.targetContext.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager manager = (WifiManager)object;
        if (manager.isWifiEnabled() == isEnabled) {
            return true;
        }
        manager.setWifiEnabled(isEnabled);
        return manager.isWifiEnabled() == isEnabled;
    }

    private final boolean changeWiFiStateUsingAdbServer(boolean isEnabled, String changeCommand) {
        boolean bl;
        try {
            Pair pair;
            boolean bl2 = isEnabled;
            if (bl2) {
                pair = TuplesKt.to((Object)CMD_STATE_ENABLE, (Object)"1");
            } else if (!bl2) {
                pair = TuplesKt.to((Object)CMD_STATE_DISABLE, (Object)"0");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            String state = (String)pair2.component1();
            String expectedResult = (String)pair2.component2();
            String[] stringArray = new String[]{changeCommand + ' ' + state};
            this.adbServer.performShell(stringArray);
            bl = (Boolean)FlakySafetyAlgorithm.invokeFlakySafely$default(this.flakySafetyAlgorithm, this.getFlakySafetyParams(), null, (Function0)new Function0<Boolean>(this, expectedResult){
                final /* synthetic */ NetworkImpl this$0;
                final /* synthetic */ String $expectedResult;
                {
                    this.this$0 = $receiver;
                    this.$expectedResult = $expectedResult;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    String string;
                    Object object = new String[]{"settings get global wifi_on"};
                    List<String> result = NetworkImpl.access$getAdbServer$p(this.this$0).performShell((String)object);
                    object = NetworkImpl.access$parseAdbResponse(this.this$0, result);
                    if (object == null) {
                        string = null;
                    } else {
                        Object object2 = object;
                        boolean bl = false;
                        string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
                    }
                    if (!Intrinsics.areEqual(string, (Object)this.$expectedResult)) {
                        throw new AdbServerException("Failed to change Wi-Fi state using ABD");
                    }
                    return true;
                }
            }, 2, null);
        }
        catch (AdbServerException e2) {
            bl = false;
        }
        return bl;
    }

    private final void changeWifiStateUsingAndroidSettings(boolean isEnabled) {
        WiFiSettingsScreen.INSTANCE.invoke((Function1)new Function1<WiFiSettingsScreen, Unit>(this, isEnabled){
            final /* synthetic */ NetworkImpl this$0;
            final /* synthetic */ boolean $isEnabled;
            {
                this.this$0 = $receiver;
                this.$isEnabled = $isEnabled;
                super(1);
            }

            public final void invoke(@NotNull WiFiSettingsScreen $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$invoke), (String)"$this$invoke");
                $this$invoke.open(NetworkImpl.access$getTargetContext$p(this.this$0));
                boolean bl = this.$isEnabled;
                if (bl) {
                    $this$invoke.enableWifi();
                } else if (!bl) {
                    $this$invoke.disableWifi();
                }
                $this$invoke.close(NetworkImpl.access$getTargetContext$p(this.this$0));
            }
        });
    }

    private final String parseAdbResponse(List<String> response) {
        Sequence sequence;
        String string;
        String string2 = (String)CollectionsKt.firstOrNull(response);
        String string3 = string2 == null ? null : (string = (sequence = StringsKt.lineSequence((CharSequence)string2)) == null ? null : (String)SequencesKt.first((Sequence)sequence));
        if (string == null) {
            return null;
        }
        String result = string;
        string2 = Regex.find$default((Regex)ADB_RESULT_REGEX, (CharSequence)result, (int)0, (int)2, null);
        if (string2 == null) {
            return null;
        }
        String match = string2;
        String string4 = string2 = match.getDestructured();
        boolean bl = false;
        String message = (String)string4.getMatch().getGroupValues().get(2);
        return message;
    }

    public static final /* synthetic */ AdbServer access$getAdbServer$p(NetworkImpl $this) {
        return $this.adbServer;
    }

    public static final /* synthetic */ String access$parseAdbResponse(NetworkImpl $this, List response) {
        return $this.parseAdbResponse(response);
    }

    public static final /* synthetic */ Context access$getTargetContext$p(NetworkImpl $this) {
        return $this.targetContext;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/kaspersky/kaspresso/device/network/NetworkImpl$Companion;", "", "()V", "ADB_RESULT_REGEX", "Lkotlin/text/Regex;", "CMD_STATE_DISABLE", "", "CMD_STATE_ENABLE", "NETWORK_STATE_CHANGE_CMD", "NETWORK_STATE_CHANGE_ROOT_CMD", "NETWORK_STATE_CHECK_CMD", "NETWORK_STATE_CHECK_RESULT_DISABLED", "NETWORK_STATE_CHECK_RESULT_ENABLED", "WIFI_STATE_CHANGE_CMD", "WIFI_STATE_CHANGE_ROOT_CMD", "WIFI_STATE_CHECK_CMD", "WIFI_STATE_CHECK_RESULT_DISABLED", "WIFI_STATE_CHECK_RESULT_ENABLED", "kaspresso_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

