/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.permissions;

import android.app.UiAutomation;
import android.os.Process;
import android.os.UserHandle;
import com.kaspersky.kaspresso.device.permissions.HackPermissions;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/kaspersky/kaspresso/device/permissions/HackPermissionsImpl;", "Lcom/kaspersky/kaspresso/device/permissions/HackPermissions;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;)V", "uiAutomation", "Landroid/app/UiAutomation;", "getUiAutomation", "()Landroid/app/UiAutomation;", "grant", "", "packageName", "", "permission", "kaspresso_release"})
public final class HackPermissionsImpl
implements HackPermissions {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;

    public HackPermissionsImpl(@NotNull UiTestLogger logger, @NotNull InstrumentalDependencyProvider instrumentalDependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        this.logger = logger;
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
    }

    private final UiAutomation getUiAutomation() {
        return this.instrumentalDependencyProvider.getUiAutomation();
    }

    @Override
    public boolean grant(@NotNull String packageName, @NotNull String permission) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.logger.i("Attempt to grant permission=" + permission + " for packageName=" + packageName + " unfairly");
        try {
            Object[] objectArray = new Class[]{String.class, String.class, UserHandle.class};
            Method method = this.getUiAutomation().getClass().getDeclaredMethod("grantRuntimePermission", (Class<?>[])objectArray);
            objectArray = new Object[]{packageName, permission, Process.myUserHandle()};
            method.invoke((Object)this.getUiAutomation(), objectArray);
            this.logger.i("Attempt to grant permission=" + permission + " for packageName=" + packageName + " unfairly was successful");
            bl = true;
        }
        catch (Throwable error) {
            this.logger.e("Attempt to grant permission=" + permission + " for packageName=" + packageName + " unfairly failed with error=" + error);
            bl = false;
        }
        return bl;
    }
}

