/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.permissions;

import android.os.Build;
import android.util.Log;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObject;
import androidx.test.uiautomator.UiObjectNotFoundException;
import androidx.test.uiautomator.UiSelector;
import com.kaspersky.kaspresso.device.permissions.Permissions;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.internal.wait.WaitKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/kaspersky/kaspresso/device/permissions/PermissionsImpl;", "Lcom/kaspersky/kaspresso/device/permissions/Permissions;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;)V", "buttonResNameMap", "", "Lcom/kaspersky/kaspresso/device/permissions/Permissions$Button;", "", "packageInstallerPackageName", "uiDevice", "Landroidx/test/uiautomator/UiDevice;", "getUiDevice", "()Landroidx/test/uiautomator/UiDevice;", "allowViaDialog", "", "clickOn", "button", "denyViaDialog", "getPermissionDialogButtonAsUiObject", "Landroidx/test/uiautomator/UiObject;", "getResIdWithPackageName", "resId", "handlePermissionRequest", "isDialogVisible", "", "Companion", "kaspresso_release"})
public final class PermissionsImpl
implements Permissions {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final String packageInstallerPackageName;
    @NotNull
    private final Map<Permissions.Button, String> buttonResNameMap;
    @Deprecated
    private static final long DIALOG_TIMEOUT_MS = 3000L;

    public PermissionsImpl(@NotNull UiTestLogger logger, @NotNull InstrumentalDependencyProvider instrumentalDependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        this.logger = logger;
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.packageInstallerPackageName = Build.VERSION.SDK_INT > 28 ? "com.android.permissioncontroller" : "com.android.packageinstaller";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Permissions.Button.ALLOW), (Object)this.getResIdWithPackageName("permission_allow_button")), TuplesKt.to((Object)((Object)Permissions.Button.ALLOW_ALWAYS), (Object)this.getResIdWithPackageName("permission_allow_always_button")), TuplesKt.to((Object)((Object)Permissions.Button.ALLOW_FOREGROUND), (Object)this.getResIdWithPackageName("permission_allow_foreground_only_button")), TuplesKt.to((Object)((Object)Permissions.Button.DENY), (Object)this.getResIdWithPackageName("permission_deny_button"))};
        this.buttonResNameMap = MapsKt.mapOf((Pair[])pairArray);
    }

    private final UiDevice getUiDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    @Override
    public void allowViaDialog() {
        WaitKt.wait(3000L, this.logger, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PermissionsImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                PermissionsImpl.access$handlePermissionRequest(this.this$0, Permissions.Button.ALLOW);
            }
        });
        this.logger.i("Allow permission via dialog");
    }

    @Override
    public void denyViaDialog() {
        WaitKt.wait(3000L, this.logger, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PermissionsImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                PermissionsImpl.access$handlePermissionRequest(this.this$0, Permissions.Button.DENY);
            }
        });
        this.logger.i("Deny permission via dialog");
    }

    @Override
    public void clickOn(@NotNull Permissions.Button button) {
        Intrinsics.checkNotNullParameter((Object)((Object)button), (String)"button");
        WaitKt.wait(3000L, this.logger, (Function0)new Function0<Unit>(this, button){
            final /* synthetic */ PermissionsImpl this$0;
            final /* synthetic */ Permissions.Button $button;
            {
                this.this$0 = $receiver;
                this.$button = $button;
                super(0);
            }

            public final void invoke() {
                PermissionsImpl.access$handlePermissionRequest(this.this$0, this.$button);
            }
        });
        this.logger.i("Apply " + (Object)((Object)button) + " for permission via dialog");
    }

    @Override
    public boolean isDialogVisible() {
        this.logger.i("Check if permission dialog is visible");
        return (Boolean)WaitKt.wait(3000L, this.logger, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ PermissionsImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Boolean bl2;
                UiObject uiObject = PermissionsImpl.access$getPermissionDialogButtonAsUiObject(this.this$0, Permissions.Button.ALLOW);
                Boolean bl3 = bl2 = uiObject == null ? null : Boolean.valueOf(uiObject.exists());
                return bl2 == null ? ((uiObject = PermissionsImpl.access$getPermissionDialogButtonAsUiObject(this.this$0, Permissions.Button.DENY)) == null ? false : (bl = uiObject.exists())) : bl2;
            }
        });
    }

    private final void handlePermissionRequest(Permissions.Button button) {
        UiObject uiObjectButton = this.getPermissionDialogButtonAsUiObject(button);
        if (uiObjectButton != null && uiObjectButton.exists()) {
            uiObjectButton.click();
        } else {
            this.logger.e("In method handlePermissionRequest button=" + (Object)((Object)button) + " is not exist or is not found.");
        }
    }

    private final UiObject getPermissionDialogButtonAsUiObject(Permissions.Button button) {
        UiObject uiObject;
        try {
            UiSelector btnSelector = new UiSelector().clickable(true).checkable(false).resourceId(this.buttonResNameMap.get((Object)button));
            uiObject = this.getUiDevice().findObject(btnSelector);
        }
        catch (UiObjectNotFoundException e2) {
            this.logger.e("There are no permissions dialog to interact with.");
            uiObject = null;
        }
        catch (Throwable e3) {
            String string = Log.getStackTraceString((Throwable)e3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTraceString(e)");
            this.logger.e(string);
            throw e3;
        }
        return uiObject;
    }

    private final String getResIdWithPackageName(String resId) {
        return this.packageInstallerPackageName + ":id/" + resId;
    }

    public static final /* synthetic */ void access$handlePermissionRequest(PermissionsImpl $this, Permissions.Button button) {
        $this.handlePermissionRequest(button);
    }

    public static final /* synthetic */ UiObject access$getPermissionDialogButtonAsUiObject(PermissionsImpl $this, Permissions.Button button) {
        return $this.getPermissionDialogButtonAsUiObject(button);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/kaspresso/device/permissions/PermissionsImpl$Companion;", "", "()V", "DIALOG_TIMEOUT_MS", "", "kaspresso_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

