/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.phone;

import com.kaspersky.kaspresso.device.phone.Phone;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/kaspersky/kaspresso/device/phone/PhoneImpl;", "Lcom/kaspersky/kaspresso/device/phone/Phone;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "cancelCall", "", "number", "", "emulateCall", "receiveSms", "text", "kaspresso_release"})
public final class PhoneImpl
implements Phone {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final AdbServer adbServer;

    public PhoneImpl(@NotNull UiTestLogger logger, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.adbServer = adbServer;
    }

    @Override
    public void emulateCall(@NotNull String number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.logger.i(Intrinsics.stringPlus((String)"Emulate incoming call from ", (Object)number));
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"emu gsm call ", (Object)number)};
        this.adbServer.performAdb(stringArray);
    }

    @Override
    public void cancelCall(@NotNull String number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.logger.i(Intrinsics.stringPlus((String)"Cancel incoming call from ", (Object)number));
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"emu gsm cancel ", (Object)number)};
        this.adbServer.performAdb(stringArray);
    }

    @Override
    public void receiveSms(@NotNull String number, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.logger.i(Intrinsics.stringPlus((String)"Emulate receiving an sms from ", (Object)number));
        String[] stringArray = new String[]{"emu sms send " + number + ' ' + text};
        this.adbServer.performAdb(stringArray);
    }
}

