/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.screenshots;

import android.util.Log;
import com.kaspersky.kaspresso.device.screenshots.Screenshots;
import com.kaspersky.kaspresso.device.screenshots.screenshotmaker.ScreenshotMaker;
import com.kaspersky.kaspresso.files.resources.ResourceFilesProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0019\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/kaspersky/kaspresso/device/screenshots/ScreenshotsImpl;", "Lcom/kaspersky/kaspresso/device/screenshots/Screenshots;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "resourceFilesProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;", "screenshotMaker", "Lcom/kaspersky/kaspresso/device/screenshots/screenshotmaker/ScreenshotMaker;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;Lcom/kaspersky/kaspresso/device/screenshots/screenshotmaker/ScreenshotMaker;)V", "doTakeAndApply", "", "tag", "", "block", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ExtensionFunctionType;", "take", "takeAndApply", "kaspresso_release"})
public final class ScreenshotsImpl
implements Screenshots {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final ResourceFilesProvider resourceFilesProvider;
    @NotNull
    private final ScreenshotMaker screenshotMaker;

    public ScreenshotsImpl(@NotNull UiTestLogger logger, @NotNull ResourceFilesProvider resourceFilesProvider, @NotNull ScreenshotMaker screenshotMaker) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceFilesProvider, (String)"resourceFilesProvider");
        Intrinsics.checkNotNullParameter((Object)screenshotMaker, (String)"screenshotMaker");
        this.logger = logger;
        this.resourceFilesProvider = resourceFilesProvider;
        this.screenshotMaker = screenshotMaker;
    }

    @Override
    public void take(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.doTakeAndApply(tag, null);
    }

    @Override
    public void takeAndApply(@NotNull String tag, @NotNull Function1<? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.doTakeAndApply(tag, block);
    }

    private final void doTakeAndApply(String tag, Function1<? super File, Unit> block) {
        try {
            File screenshotFile = ResourceFilesProvider.DefaultImpls.provideScreenshotFile$default(this.resourceFilesProvider, tag, null, 2, null);
            this.screenshotMaker.takeScreenshot(screenshotFile);
            Function1<? super File, Unit> function1 = block;
            if (function1 != null) {
                function1.invoke((Object)screenshotFile);
            }
            this.logger.i(Intrinsics.stringPlus((String)"Screenshot saved to ", (Object)screenshotFile));
        }
        catch (Throwable e2) {
            this.logger.e(Intrinsics.stringPlus((String)"An error while making screenshot occurred: ", (Object)Log.getStackTraceString((Throwable)e2)));
        }
    }
}

