/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.server;

import com.kaspersky.adbserver.common.api.CommandResult;
import com.kaspersky.adbserver.common.log.logger.LogLevel;
import com.kaspersky.adbserver.common.log.logger.Logger;
import com.kaspersky.adbserver.device.AdbTerminal;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.device.server.AdbServerImpl;
import com.kaspersky.kaspresso.device.server.AdbServerLoggerKaspressoImpl;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/kaspersky/kaspresso/device/server/AdbServerImpl;", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "logLevel", "Lcom/kaspersky/adbserver/common/log/logger/LogLevel;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/adbserver/common/log/logger/LogLevel;Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "adbServerLogger", "Lcom/kaspersky/adbserver/common/log/logger/Logger;", "adbTerminal", "Lcom/kaspersky/adbserver/device/AdbTerminal;", "getAdbTerminal", "()Lcom/kaspersky/adbserver/device/AdbTerminal;", "connected", "", "disconnectServer", "", "perform", "", "", "commands", "", "executor", "Lkotlin/Function1;", "Lcom/kaspersky/adbserver/common/api/CommandResult;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "performAdb", "([Ljava/lang/String;)Ljava/util/List;", "performCmd", "performShell", "kaspresso_release"})
public final class AdbServerImpl
implements AdbServer {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Logger adbServerLogger;
    private boolean connected;

    public AdbServerImpl(@NotNull LogLevel logLevel, @NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.adbServerLogger = new AdbServerLoggerKaspressoImpl(logLevel, this.logger);
    }

    private final AdbTerminal getAdbTerminal() {
        if (!this.connected) {
            AdbTerminal.INSTANCE.connect(this.adbServerLogger);
            this.connected = true;
        }
        return AdbTerminal.INSTANCE;
    }

    @Override
    @NotNull
    public List<String> performCmd(String ... commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        return this.perform(commands, (Function1<? super String, CommandResult>)((Function1)new Function1<String, CommandResult>(this){
            final /* synthetic */ AdbServerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CommandResult invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AdbServerImpl.access$getAdbTerminal(this.this$0).executeCmd(it);
            }
        }));
    }

    @Override
    @NotNull
    public List<String> performAdb(String ... commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        return this.perform(commands, (Function1<? super String, CommandResult>)((Function1)new Function1<String, CommandResult>(this){
            final /* synthetic */ AdbServerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CommandResult invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AdbServerImpl.access$getAdbTerminal(this.this$0).executeAdb(it);
            }
        }));
    }

    @Override
    @NotNull
    public List<String> performShell(String ... commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        return this.perform(commands, (Function1<? super String, CommandResult>)((Function1)new Function1<String, CommandResult>(this){
            final /* synthetic */ AdbServerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CommandResult invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AdbServerImpl.access$getAdbTerminal(this.this$0).executeAdb(Intrinsics.stringPlus((String)"shell ", (Object)it));
            }
        }));
    }

    @Override
    public void disconnectServer() {
        if (this.connected) {
            this.getAdbTerminal().disconnect();
            this.connected = false;
        }
    }

    private final List<String> perform(String[] commands, Function1<? super String, CommandResult> executor) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)ArraysKt.asSequence((Object[])commands), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ AdbServerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                AdbServerImpl.access$getLogger$p(this.this$0).i(Intrinsics.stringPlus((String)"AdbServer. The command to execute=", (Object)command));
            }
        })), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends CommandResult>>(executor){
            final /* synthetic */ Function1<String, CommandResult> $executor;
            {
                this.$executor = $executor;
                super(1);
            }

            @NotNull
            public final Pair<String, CommandResult> invoke(@NotNull String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                return TuplesKt.to((Object)command, (Object)this.$executor.invoke((Object)command));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends CommandResult>, Unit>(this){
            final /* synthetic */ AdbServerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<String, CommandResult> $dstr$command$result) {
                Intrinsics.checkNotNullParameter($dstr$command$result, (String)"$dstr$command$result");
                String command = (String)$dstr$command$result.component1();
                CommandResult result = (CommandResult)$dstr$command$result.component2();
                AdbServerImpl.access$getLogger$p(this.this$0).i("AdbServer. The command=" + command + " was performed with result=" + result);
            }
        })), (Function1)perform.4.INSTANCE), (Function1)perform.5.INSTANCE));
    }

    public static final /* synthetic */ AdbTerminal access$getAdbTerminal(AdbServerImpl $this) {
        return $this.getAdbTerminal();
    }

    public static final /* synthetic */ UiTestLogger access$getLogger$p(AdbServerImpl $this) {
        return $this.logger;
    }
}

