/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.video.recorder;

import android.util.Log;
import androidx.test.uiautomator.UiDevice;
import com.kaspersky.kaspresso.device.video.recorder.VideoRecorder;
import com.kaspersky.kaspresso.device.video.recorder.VideoRecordingThread;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.internal.wait.WaitKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.VideoParams;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u000f\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/kaspersky/kaspresso/device/video/recorder/VideoRecorderImpl;", "Lcom/kaspersky/kaspresso/device/video/recorder/VideoRecorder;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "params", "Lcom/kaspersky/kaspresso/params/VideoParams;", "(Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/params/VideoParams;)V", "device", "Landroidx/test/uiautomator/UiDevice;", "getDevice", "()Landroidx/test/uiautomator/UiDevice;", "videoRecordingThread", "Lcom/kaspersky/kaspresso/device/video/recorder/VideoRecordingThread;", "doAfterRecordingStopped", "", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lkotlin/Unit;", "getErrorMessage", "", "error", "", "start", "file", "Ljava/io/File;", "stop", "waitForRecordingToStart", "()Lkotlin/Unit;", "kaspresso_release"})
public final class VideoRecorderImpl
implements VideoRecorder {
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final VideoParams params;
    @Nullable
    private VideoRecordingThread videoRecordingThread;

    public VideoRecorderImpl(@NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull UiTestLogger logger, @NotNull VideoParams params) {
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.logger = logger;
        this.params = params;
    }

    private final UiDevice getDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull File file) {
        void $this$start_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.videoRecordingThread != null) {
            this.logger.i(Intrinsics.stringPlus((String)"Can't start video recording as it is already started: ", (Object)file.getName()));
            return;
        }
        this.logger.i(Intrinsics.stringPlus((String)"Starting video recording: ", (Object)file.getName()));
        VideoRecordingThread videoRecordingThread = new VideoRecordingThread(this.getDevice(), this.logger, this.params, file);
        boolean bl = false;
        boolean bl2 = false;
        VideoRecordingThread videoRecordingThread2 = videoRecordingThread;
        VideoRecorderImpl videoRecorderImpl = this;
        boolean bl3 = false;
        $this$start_u24lambda_u2d0.start();
        Unit unit = Unit.INSTANCE;
        videoRecorderImpl.videoRecordingThread = videoRecordingThread;
        this.waitForRecordingToStart();
    }

    @Override
    @Nullable
    public File stop() {
        VideoRecordingThread videoRecordingThread = this.videoRecordingThread;
        if (videoRecordingThread == null) {
            VideoRecorderImpl videoRecorderImpl = this;
            boolean bl = false;
            boolean bl2 = false;
            VideoRecorderImpl $this$stop_u24lambda_u2d1 = videoRecorderImpl;
            boolean bl3 = false;
            $this$stop_u24lambda_u2d1.logger.i("Can't stop video recording as it was not started");
            return null;
        }
        VideoRecordingThread thread = videoRecordingThread;
        this.logger.i("Stopping video recording");
        thread.killRecordingProcess();
        this.doAfterRecordingStopped((Function0<Unit>)((Function0)new Function0<Unit>(thread, this){
            final /* synthetic */ VideoRecordingThread $thread;
            final /* synthetic */ VideoRecorderImpl this$0;
            {
                this.$thread = $thread;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$thread.interrupt();
                VideoRecorderImpl.access$setVideoRecordingThread$p(this.this$0, null);
            }
        }));
        return thread.getFile();
    }

    private final Unit waitForRecordingToStart() {
        return (Unit)WaitKt.wait(this.params.getStartRecordingTimeMs(), this.logger, SetsKt.setOf(InterruptedException.class), (Function1<? super Throwable, String>)((Function1)new Function1<Throwable, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VideoRecorderImpl.access$getErrorMessage((VideoRecorderImpl)this.receiver, p0);
            }
        }), null);
    }

    private final Unit doAfterRecordingStopped(Function0<Unit> action) {
        return WaitKt.wait(this.params.getStopRecordingTimeMs(), this.logger, SetsKt.setOf(InterruptedException.class), (Function1<? super Throwable, String>)((Function1)new Function1<Throwable, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VideoRecorderImpl.access$getErrorMessage((VideoRecorderImpl)this.receiver, p0);
            }
        }), action);
    }

    private final String getErrorMessage(Throwable error) {
        return Intrinsics.stringPlus((String)"Video recording was interrupted:\n", (Object)Log.getStackTraceString((Throwable)error));
    }

    public static final /* synthetic */ void access$setVideoRecordingThread$p(VideoRecorderImpl $this, VideoRecordingThread videoRecordingThread) {
        $this.videoRecordingThread = videoRecordingThread;
    }

    public static final /* synthetic */ String access$getErrorMessage(VideoRecorderImpl $this, Throwable error) {
        return $this.getErrorMessage(error);
    }
}

