/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.video.recorder;

import androidx.test.uiautomator.UiDevice;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.VideoParams;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kaspersky/kaspresso/device/video/recorder/VideoRecordingThread;", "Ljava/lang/Thread;", "device", "Landroidx/test/uiautomator/UiDevice;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "params", "Lcom/kaspersky/kaspresso/params/VideoParams;", "file", "Ljava/io/File;", "(Landroidx/test/uiautomator/UiDevice;Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/params/VideoParams;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "execShellCommand", "", "command", "", "killRecordingProcess", "run", "start", "kaspresso_release"})
public final class VideoRecordingThread
extends Thread {
    @NotNull
    private final UiDevice device;
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final VideoParams params;
    @NotNull
    private final File file;

    public VideoRecordingThread(@NotNull UiDevice device, @NotNull UiTestLogger logger, @NotNull VideoParams params, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.device = device;
        this.logger = logger;
        this.params = params;
        this.file = file;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    public void start() {
        this.setPriority(10);
        super.start();
    }

    @Override
    public void run() {
        this.execShellCommand("screenrecord --bit-rate " + this.params.getBitRate() + " --bugreport " + this.file.getAbsolutePath());
    }

    public final void killRecordingProcess() {
        this.execShellCommand("pkill -l INT screenrecord");
    }

    private final void execShellCommand(String command) {
        try {
            String string = this.device.executeShellCommand(command);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.executeShellCommand(command)");
            boolean bl = false;
            ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        catch (Throwable e2) {
            this.logger.e("Adb shell command:\n" + command + "\nexecution failure: " + e2.getMessage());
        }
    }
}

