/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.device.viewhierarchy;

import android.util.Log;
import androidx.test.uiautomator.UiDevice;
import com.kaspersky.kaspresso.device.viewhierarchy.ViewHierarchyDumper;
import com.kaspersky.kaspresso.files.resources.ResourceFilesProvider;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J)\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0002\b\u0014H\u0016R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/kaspersky/kaspresso/device/viewhierarchy/ViewHierarchyDumperImpl;", "Lcom/kaspersky/kaspresso/device/viewhierarchy/ViewHierarchyDumper;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "resourceFilesProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;", "(Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;)V", "device", "Landroidx/test/uiautomator/UiDevice;", "getDevice", "()Landroidx/test/uiautomator/UiDevice;", "doDumpAndApply", "", "tag", "", "block", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ExtensionFunctionType;", "dump", "dumpAndApply", "kaspresso_release"})
public final class ViewHierarchyDumperImpl
implements ViewHierarchyDumper {
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final ResourceFilesProvider resourceFilesProvider;

    public ViewHierarchyDumperImpl(@NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull UiTestLogger logger, @NotNull ResourceFilesProvider resourceFilesProvider) {
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceFilesProvider, (String)"resourceFilesProvider");
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.logger = logger;
        this.resourceFilesProvider = resourceFilesProvider;
    }

    private final UiDevice getDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    @Override
    public void dump(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.doDumpAndApply(tag, null);
    }

    @Override
    public void dumpAndApply(@NotNull String tag, @NotNull Function1<? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.doDumpAndApply(tag, block);
    }

    private final void doDumpAndApply(String tag, Function1<? super File, Unit> block) {
        try {
            File viewHierarchyFile = ResourceFilesProvider.DefaultImpls.provideViewHierarchyFile$default(this.resourceFilesProvider, tag, null, 2, null);
            this.getDevice().dumpWindowHierarchy(viewHierarchyFile);
            Function1<? super File, Unit> function1 = block;
            if (function1 != null) {
                function1.invoke((Object)viewHierarchyFile);
            }
            this.logger.i(Intrinsics.stringPlus((String)"View hierarchy dumped to ", (Object)viewHierarchyFile));
        }
        catch (Throwable e2) {
            this.logger.e(Intrinsics.stringPlus((String)"View hierarchy dumping error occurred: ", (Object)Log.getStackTraceString((Throwable)e2)));
        }
    }
}

