/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.docloc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Process;
import com.kaspersky.kaspresso.device.permissions.HackPermissions;
import com.kaspersky.kaspresso.docloc.DocLocException;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/kaspersky/kaspresso/docloc/SystemLanguage;", "", "context", "Landroid/content/Context;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "hackPermissions", "Lcom/kaspersky/kaspresso/device/permissions/HackPermissions;", "(Landroid/content/Context;Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/device/permissions/HackPermissions;)V", "grantPermissionsIfNeed", "", "switch", "locale", "Ljava/util/Locale;", "kaspresso_release"})
public final class SystemLanguage {
    @NotNull
    private final Context context;
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final HackPermissions hackPermissions;

    public SystemLanguage(@NotNull Context context, @NotNull UiTestLogger logger, @NotNull HackPermissions hackPermissions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)hackPermissions, (String)"hackPermissions");
        this.context = context;
        this.logger = logger;
        this.hackPermissions = hackPermissions;
    }

    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    public final void switch(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.logger.i("SystemLanguage: Installing new system language=" + locale + " started");
        this.grantPermissionsIfNeed();
        try {
            Class<?> cls = Class.forName("android.app.ActivityManagerNative");
            Object amService = cls.getDeclaredMethod("getDefault", new Class[0]).invoke(cls, new Object[0]);
            Object[] objectArray = amService.getClass().getDeclaredMethod("getConfiguration", new Class[0]).invoke(amService, new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.content.res.Configuration");
            }
            Configuration configuration = (Configuration)objectArray;
            configuration.getClass().getDeclaredField("userSetLocale").setBoolean(configuration, true);
            configuration.getClass().getDeclaredField("locale").set(configuration, locale);
            objectArray = new Class[]{Configuration.class};
            Method method = amService.getClass().getDeclaredMethod("updateConfiguration", (Class<?>[])objectArray);
            objectArray = new Object[]{configuration};
            method.invoke(amService, objectArray);
            this.logger.i("SystemLanguage: Installing new system language=" + locale + " completed");
        }
        catch (Throwable error) {
            this.logger.e("SystemLanguage: Installing new system language=" + locale + " failed with error=" + error);
            throw error;
        }
    }

    private final void grantPermissionsIfNeed() {
        int permissionStateAtTheBeginning = this.context.checkPermission("android.permission.CHANGE_CONFIGURATION", Process.myPid(), Process.myUid());
        if (permissionStateAtTheBeginning == 0) {
            return;
        }
        String string = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        boolean attemptToGrantPermissionResult = this.hackPermissions.grant(string, "android.permission.CHANGE_CONFIGURATION");
        if (!attemptToGrantPermissionResult) {
            throw new DocLocException("SystemLanguage: The attempt to grant Manifest.permission.CHANGE_CONFIGURATION for SystemLanguage failed");
        }
    }
}

