/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.docloc.rule;

import com.kaspersky.kaspresso.device.Device;
import com.kaspersky.kaspresso.docloc.SystemLanguage;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/kaspersky/kaspresso/docloc/rule/LocaleRule;", "Lorg/junit/rules/TestRule;", "locales", "", "Ljava/util/Locale;", "device", "Lcom/kaspersky/kaspresso/device/Device;", "changeSystemLocale", "", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Ljava/util/Set;Lcom/kaspersky/kaspresso/device/Device;ZLcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "currentLocale", "currentLocaleName", "", "getCurrentLocaleName", "()Ljava/lang/String;", "deviceLocale", "systemLanguage", "Lcom/kaspersky/kaspresso/docloc/SystemLanguage;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "changeLanguageInApp", "", "changeLanguageInOs", "kaspresso_release"})
public final class LocaleRule
implements TestRule {
    @NotNull
    private final Set<Locale> locales;
    @NotNull
    private final Device device;
    private final boolean changeSystemLocale;
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final SystemLanguage systemLanguage;
    @NotNull
    private final Locale deviceLocale;
    @Nullable
    private Locale currentLocale;

    public LocaleRule(@NotNull Set<Locale> locales, @NotNull Device device, boolean changeSystemLocale, @NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter(locales, (String)"locales");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.locales = locales;
        this.device = device;
        this.changeSystemLocale = changeSystemLocale;
        this.logger = logger;
        this.systemLanguage = new SystemLanguage(this.device.getTargetContext(), this.logger, this.device.getHackPermissions());
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        this.deviceLocale = locale;
    }

    @NotNull
    public final String getCurrentLocaleName() {
        return String.valueOf(this.currentLocale);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new Statement(this, base){
            final /* synthetic */ LocaleRule this$0;
            final /* synthetic */ Statement $base;
            {
                this.this$0 = $receiver;
                this.$base = $base;
            }

            public void evaluate() {
                if (LocaleRule.access$getChangeSystemLocale$p(this.this$0)) {
                    LocaleRule.access$changeLanguageInOs(this.this$0, this.$base);
                } else {
                    LocaleRule.access$changeLanguageInApp(this.this$0, this.$base);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeLanguageInApp(Statement base) {
        this.logger.i("DocLoc: changeLanguageInApp started");
        try {
            Iterable $this$onEach$iv = this.locales;
            boolean $i$f$onEach = false;
            Iterable iterable = $this$onEach$iv;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$apply$iv = iterable;
            boolean bl3 = false;
            for (Object element$iv : $this$apply$iv) {
                Locale locale = (Locale)element$iv;
                boolean bl4 = false;
                this.currentLocale = locale;
                this.logger.i("DocLoc: changeLanguageInApp is processing. New language=" + locale + " is installing");
                this.device.getLanguage().switchInApp(locale);
                this.logger.i("DocLoc: changeLanguageInApp is processing. New language=" + locale + " is installed");
                base.evaluate();
            }
        }
        finally {
            this.logger.i("DocLoc: changeLanguageInApp is finishing. Device language=" + this.deviceLocale + " is restoring");
            this.currentLocale = this.deviceLocale;
            this.device.getLanguage().switchInApp(this.deviceLocale);
            this.logger.i("DocLoc: changeLanguageInApp is finishing. Device language=" + this.deviceLocale + " is restored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeLanguageInOs(Statement base) {
        this.logger.i("DocLoc: changeLanguageInOs started");
        try {
            Iterable $this$onEach$iv = this.locales;
            boolean $i$f$onEach = false;
            Iterable iterable = $this$onEach$iv;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$apply$iv = iterable;
            boolean bl3 = false;
            for (Object element$iv : $this$apply$iv) {
                Locale locale = (Locale)element$iv;
                boolean bl4 = false;
                this.currentLocale = locale;
                this.logger.i("DocLoc: changeLanguageInOs is processing. New language=" + locale + " is installing");
                this.systemLanguage.switch(locale);
                this.logger.i("DocLoc: changeLanguageInOs is processing. New language=" + locale + " is installed");
                base.evaluate();
            }
        }
        finally {
            this.logger.i("DocLoc: changeLanguageInOs is finishing. Device language=" + this.deviceLocale + " is restoring");
            this.currentLocale = this.deviceLocale;
            this.systemLanguage.switch(this.deviceLocale);
            this.logger.i("DocLoc: changeLanguageInOs is finishing. Device language=" + this.deviceLocale + " is restored");
        }
    }

    public static final /* synthetic */ boolean access$getChangeSystemLocale$p(LocaleRule $this) {
        return $this.changeSystemLocale;
    }

    public static final /* synthetic */ void access$changeLanguageInOs(LocaleRule $this, Statement base) {
        $this.changeLanguageInOs(base);
    }

    public static final /* synthetic */ void access$changeLanguageInApp(LocaleRule $this, Statement base) {
        $this.changeLanguageInApp(base);
    }
}

