/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.failure;

import android.util.Log;
import android.view.View;
import androidx.test.espresso.PerformException;
import com.kaspersky.kaspresso.failure.FailureLoggingProvider;
import com.kaspersky.kaspresso.internal.extensions.espressoext.MatchersExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import io.reactivex.exceptions.ExtCompositeException;
import junit.framework.AssertionFailedError;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\b*\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/kaspersky/kaspresso/failure/FailureLoggingProviderImpl;", "Lcom/kaspersky/kaspresso/failure/FailureLoggingProvider;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "logDescriptionAndThrow", "", "error", "", "viewMatcher", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "logStackTrace", "withLoggingOnFailure", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "describedWith", "kaspresso_release"})
public final class FailureLoggingProviderImpl
implements FailureLoggingProvider {
    @NotNull
    private final UiTestLogger logger;

    public FailureLoggingProviderImpl(@NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    public <T> T withLoggingOnFailure(@NotNull Function0<? extends T> action) throws Throwable {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            object = action.invoke();
        }
        catch (Throwable error) {
            this.logStackTrace(error);
            throw error;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logStackTrace(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Object object = Log.getStackTraceString((Throwable)error);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getStackTraceString(error)");
        this.logger.e((String)object);
        if (error instanceof ExtCompositeException) {
            object = ((ExtCompositeException)error).getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"error.exceptions");
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void e2;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Throwable throwable = (Throwable)item$iv;
                int i2 = n;
                boolean bl2 = false;
                this.logger.e("Composed exception " + (i2 + 1) + " :");
                String string = Log.getStackTraceString((Throwable)e2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTraceString(e)");
                this.logger.e(string);
            }
        }
    }

    @Override
    public void logDescriptionAndThrow(@Nullable Throwable error, @Nullable Matcher<View> viewMatcher) throws Throwable {
        boolean bl;
        boolean bl2;
        Throwable throwable;
        String string;
        UiTestLogger uiTestLogger = this.logger;
        StringBuilder stringBuilder = new StringBuilder().append("Failed to interact with view matching: ").append(MatchersExtKt.describe(viewMatcher));
        Throwable throwable2 = error;
        if (throwable2 == null) {
            string = null;
        } else {
            throwable = throwable2;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable;
            StringBuilder stringBuilder2 = stringBuilder;
            UiTestLogger uiTestLogger2 = uiTestLogger;
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)" because of ", (Object)error.getClass().getSimpleName());
            uiTestLogger = uiTestLogger2;
            stringBuilder = stringBuilder2;
            string = string2;
        }
        uiTestLogger.e(stringBuilder.append((Object)string).toString());
        throwable2 = error;
        if (throwable2 != null) {
            throwable = throwable2;
            bl2 = false;
            bl = false;
            Throwable it = throwable;
            boolean bl4 = false;
            throw this.describedWith(it, viewMatcher);
        }
    }

    private final Throwable describedWith(Throwable $this$describedWith, Matcher<View> viewMatcher) {
        Throwable throwable;
        boolean bl;
        Throwable throwable2 = $this$describedWith;
        if (throwable2 instanceof PerformException) {
            PerformException.Builder builder = new PerformException.Builder().from((PerformException)$this$describedWith);
            bl = false;
            boolean bl2 = false;
            PerformException.Builder $this$describedWith_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            Matcher<View> matcher = viewMatcher;
            if (matcher != null) {
                Matcher<View> matcher2 = matcher;
                boolean bl4 = false;
                boolean bl5 = false;
                Matcher<View> it = matcher2;
                boolean bl6 = false;
                $this$describedWith_u24lambda_u2d4.withViewDescription(it.toString());
            }
            throwable = (Throwable)builder.build();
        } else {
            throwable = throwable2 instanceof AssertionError ? new AssertionFailedError($this$describedWith.getMessage()).initCause($this$describedWith) : $this$describedWith;
        }
        throwable2 = throwable;
        boolean bl7 = false;
        bl = false;
        Throwable $this$describedWith_u24lambda_u2d5 = throwable2;
        boolean bl8 = false;
        $this$describedWith_u24lambda_u2d5.setStackTrace(Thread.currentThread().getStackTrace());
        Throwable throwable3 = throwable2;
        Intrinsics.checkNotNullExpressionValue((Object)throwable3, (String)"when (this) {\n          \u2026rentThread().stackTrace }");
        return throwable3;
    }
}

