/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.files.dirs;

import android.annotation.SuppressLint;
import android.app.Instrumentation;
import android.os.Build;
import android.os.Environment;
import com.kaspersky.kaspresso.files.dirs.DirsProvider;
import com.kaspersky.kaspresso.internal.extensions.other.FileExtKt;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0017R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/kaspersky/kaspresso/files/dirs/DefaultDirsProvider;", "Lcom/kaspersky/kaspresso/files/dirs/DirsProvider;", "instrumentation", "Landroid/app/Instrumentation;", "(Landroid/app/Instrumentation;)V", "clearedDirs", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "clearDir", "", "path", "inclusive", "", "provideCleared", "dest", "provideNew", "kaspresso_release"})
public final class DefaultDirsProvider
implements DirsProvider {
    @NotNull
    private final Instrumentation instrumentation;
    @NotNull
    private final HashSet<File> clearedDirs;

    public DefaultDirsProvider(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        this.instrumentation = instrumentation;
        this.clearedDirs = new HashSet();
    }

    @Override
    @SuppressLint(value={"WorldReadableFiles", "ObsoleteSdkInt"})
    @NotNull
    public File provideNew(@NotNull File dest) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (Build.VERSION.SDK_INT >= 21) {
            file2 = Environment.getExternalStorageDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getExternalStorageDirectory()");
            file = FilesKt.resolve((File)file2, (File)dest);
        } else {
            file2 = this.instrumentation.getTargetContext().getApplicationContext().getDir(dest.getCanonicalPath(), 1);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"{\n            instrument\u2026E\n            )\n        }");
            file = file2;
        }
        File dir = file;
        return FileExtKt.createDirIfNeeded(dir);
    }

    @Override
    @NotNull
    public File provideCleared(@NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!this.clearedDirs.contains(dest)) {
            this.clearDir(dest, false);
            this.clearedDirs.add(dest);
        }
        return FileExtKt.createDirIfNeeded(dest);
    }

    private final void clearDir(File path, boolean inclusive) {
        File[] fileArray;
        if (path.isDirectory() && (fileArray = path.listFiles()) != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int j = 0; j < n; ++j) {
                File element$iv;
                File it = element$iv = fileArray2[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.clearDir(it, true);
            }
        }
        if (inclusive) {
            path.delete();
        }
    }
}

