/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.files.resources.impl;

import com.kaspersky.kaspresso.files.extensions.FileExtension;
import com.kaspersky.kaspresso.files.resources.ResourceFileNamesProvider;
import com.kaspersky.kaspresso.files.resources.ResourceFilesProvider;
import com.kaspersky.kaspresso.files.resources.ResourcesDirsProvider;
import com.kaspersky.kaspresso.files.resources.ResourcesRootDirsProvider;
import com.kaspersky.kaspresso.internal.extensions.other.FileExtKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/kaspersky/kaspresso/files/resources/impl/DefaultResourceFilesProvider;", "Lcom/kaspersky/kaspresso/files/resources/ResourceFilesProvider;", "resourcesRootDirsProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourcesRootDirsProvider;", "resourcesDirsProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourcesDirsProvider;", "resourceFileNamesProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourceFileNamesProvider;", "(Lcom/kaspersky/kaspresso/files/resources/ResourcesRootDirsProvider;Lcom/kaspersky/kaspresso/files/resources/ResourcesDirsProvider;Lcom/kaspersky/kaspresso/files/resources/ResourceFileNamesProvider;)V", "provideLogcatFile", "Ljava/io/File;", "tag", "", "subDir", "provideScreenshotFile", "provideVideoFile", "provideViewHierarchyFile", "kaspresso_release"})
public final class DefaultResourceFilesProvider
implements ResourceFilesProvider {
    @NotNull
    private final ResourcesRootDirsProvider resourcesRootDirsProvider;
    @NotNull
    private final ResourcesDirsProvider resourcesDirsProvider;
    @NotNull
    private final ResourceFileNamesProvider resourceFileNamesProvider;

    public DefaultResourceFilesProvider(@NotNull ResourcesRootDirsProvider resourcesRootDirsProvider, @NotNull ResourcesDirsProvider resourcesDirsProvider, @NotNull ResourceFileNamesProvider resourceFileNamesProvider) {
        Intrinsics.checkNotNullParameter((Object)resourcesRootDirsProvider, (String)"resourcesRootDirsProvider");
        Intrinsics.checkNotNullParameter((Object)resourcesDirsProvider, (String)"resourcesDirsProvider");
        Intrinsics.checkNotNullParameter((Object)resourceFileNamesProvider, (String)"resourceFileNamesProvider");
        this.resourcesRootDirsProvider = resourcesRootDirsProvider;
        this.resourcesDirsProvider = resourcesDirsProvider;
        this.resourceFileNamesProvider = resourceFileNamesProvider;
    }

    @Override
    @NotNull
    public File provideLogcatFile(@NotNull String tag, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String resFileName = this.resourceFileNamesProvider.getFileName(tag, FileExtension.TXT.toString());
        return FilesKt.resolve((File)this.resourcesDirsProvider.provide(this.resourcesRootDirsProvider.getLogcatRootDir(), subDir), (String)resFileName);
    }

    @Override
    @NotNull
    public File provideScreenshotFile(@NotNull String tag, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String resFileName = this.resourceFileNamesProvider.getFileName(tag, FileExtension.PNG.toString());
        return FilesKt.resolve((File)this.resourcesDirsProvider.provide(this.resourcesRootDirsProvider.getScreenshotsRootDir(), subDir), (String)resFileName);
    }

    @Override
    @NotNull
    public File provideVideoFile(@NotNull String tag, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String resFileName = this.resourceFileNamesProvider.getFileName(tag, FileExtension.MP4.toString());
        return FileExtKt.createFileIfNeeded(FilesKt.resolve((File)this.resourcesDirsProvider.provide(this.resourcesRootDirsProvider.getVideoRootDir(), subDir), (String)resFileName));
    }

    @Override
    @NotNull
    public File provideViewHierarchyFile(@NotNull String tag, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String resFileName = this.resourceFileNamesProvider.getFileName(tag, FileExtension.XML.toString());
        return FilesKt.resolve((File)this.resourcesDirsProvider.provide(this.resourcesRootDirsProvider.getViewHierarchy(), subDir), (String)resFileName);
    }
}

