/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.files.resources.impl;

import com.kaspersky.kaspresso.files.dirs.DirsProvider;
import com.kaspersky.kaspresso.files.extensions.StackTraceExtKt;
import com.kaspersky.kaspresso.files.models.TestMethod;
import com.kaspersky.kaspresso.files.resources.ResourcesDirNameProvider;
import com.kaspersky.kaspresso.files.resources.ResourcesDirsProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/kaspersky/kaspresso/files/resources/impl/DefaultResourcesDirsProvider;", "Lcom/kaspersky/kaspresso/files/resources/ResourcesDirsProvider;", "dirsProvider", "Lcom/kaspersky/kaspresso/files/dirs/DirsProvider;", "resourcesDirNameProvider", "Lcom/kaspersky/kaspresso/files/resources/ResourcesDirNameProvider;", "(Lcom/kaspersky/kaspresso/files/dirs/DirsProvider;Lcom/kaspersky/kaspresso/files/resources/ResourcesDirNameProvider;)V", "provide", "Ljava/io/File;", "dest", "subDir", "", "resolveResourcesDirDest", "rootDir", "kaspresso_release"})
public final class DefaultResourcesDirsProvider
implements ResourcesDirsProvider {
    @NotNull
    private final DirsProvider dirsProvider;
    @NotNull
    private final ResourcesDirNameProvider resourcesDirNameProvider;

    public DefaultResourcesDirsProvider(@NotNull DirsProvider dirsProvider, @NotNull ResourcesDirNameProvider resourcesDirNameProvider) {
        Intrinsics.checkNotNullParameter((Object)dirsProvider, (String)"dirsProvider");
        Intrinsics.checkNotNullParameter((Object)resourcesDirNameProvider, (String)"resourcesDirNameProvider");
        this.dirsProvider = dirsProvider;
        this.resourcesDirNameProvider = resourcesDirNameProvider;
    }

    @Override
    @NotNull
    public File provide(@NotNull File dest, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        File rootDir = this.dirsProvider.provideNew(dest);
        File resourcesDest = this.resolveResourcesDirDest(rootDir, subDir);
        return this.dirsProvider.provideCleared(resourcesDest);
    }

    private final File resolveResourcesDirDest(File rootDir, String subDir) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
        TestMethod testMethod = StackTraceExtKt.findTestMethod(stackTraceElementArray);
        String resourcesDirName = this.resourcesDirNameProvider.provideResourcesDirName(testMethod);
        String string = subDir;
        return string == null ? FilesKt.resolve((File)rootDir, (String)resourcesDirName) : FilesKt.resolve((File)FilesKt.resolve((File)rootDir, (String)subDir), (String)resourcesDirName);
    }

    static /* synthetic */ File resolveResourcesDirDest$default(DefaultResourcesDirsProvider defaultResourcesDirsProvider, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return defaultResourcesDirsProvider.resolveResourcesDirDest(file, string);
    }
}

