/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.flakysafety.algorithm;

import com.kaspersky.kaspresso.internal.extensions.other.ThrowableExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.params.FlakySafetyParams;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0011\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/kaspersky/kaspresso/flakysafety/algorithm/FlakySafetyAlgorithm;", "", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "invokeFlakySafely", "T", "params", "Lcom/kaspersky/kaspresso/params/FlakySafetyParams;", "failureMessage", "", "action", "Lkotlin/Function0;", "(Lcom/kaspersky/kaspresso/params/FlakySafetyParams;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kaspresso_release"})
public final class FlakySafetyAlgorithm {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final ReentrantLock lock;
    private final Condition condition;

    public FlakySafetyAlgorithm(@NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T invokeFlakySafely(@NotNull FlakySafetyParams params, @Nullable String failureMessage, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Throwable cachedError = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                return (T)action.invoke();
            }
            catch (Throwable error) {
                if (ThrowableExtKt.isAllowed(error, params.getAllowedExceptions())) {
                    cachedError = error;
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        Timer timer = new Timer();
                        long l = params.getIntervalMs();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        TimerTask timerTask = new TimerTask(this){
                            final /* synthetic */ FlakySafetyAlgorithm this$0;
                            {
                                this.this$0 = flakySafetyAlgorithm;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                TimerTask $this$invokeFlakySafely_u24lambda_u2d2_u24lambda_u2d1 = this;
                                boolean bl = false;
                                Lock lock = FlakySafetyAlgorithm.access$getLock$p(this.this$0);
                                boolean bl2 = false;
                                boolean bl3 = false;
                                lock.lock();
                                try {
                                    boolean bl4 = false;
                                    FlakySafetyAlgorithm.access$getCondition$p(this.this$0).signalAll();
                                    Unit unit = Unit.INSTANCE;
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        };
                        timer.schedule(timerTask, l);
                        this.condition.await();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                } else {
                    throw error;
                }
                if (System.currentTimeMillis() - startTime <= params.getTimeoutMs()) continue;
                this.logger.e("All attempts to interact for " + params.getTimeoutMs() + " ms totally failed because of " + cachedError.getClass().getSimpleName());
                throw ThrowableExtKt.withMessage(cachedError, failureMessage);
            }
            break;
        }
    }

    public static /* synthetic */ Object invokeFlakySafely$default(FlakySafetyAlgorithm flakySafetyAlgorithm, FlakySafetyParams flakySafetyParams, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return flakySafetyAlgorithm.invokeFlakySafely(flakySafetyParams, string, function0);
    }

    public static final /* synthetic */ Condition access$getCondition$p(FlakySafetyAlgorithm $this) {
        return $this.condition;
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(FlakySafetyAlgorithm $this) {
        return $this.lock;
    }
}

