/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.instrumental;

import android.app.Instrumentation;
import android.app.UiAutomation;
import androidx.annotation.RequiresApi;
import androidx.test.uiautomator.UiDevice;
import com.kaspersky.components.kautomator.common.Environment;
import com.kaspersky.components.kautomator.common.EnvironmentDetectorKt;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.instrumental.InstrumentalUsage;
import com.kaspersky.kaspresso.instrumental.exception.NotSupportedInstrumentalTestException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProviderImpl;", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "location", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalUsage;", "instrumentation", "Landroid/app/Instrumentation;", "(Lcom/kaspersky/kaspresso/instrumental/InstrumentalUsage;Landroid/app/Instrumentation;)V", "isAndroidRuntime", "", "()Z", "uiAutomation", "Landroid/app/UiAutomation;", "getUiAutomation", "()Landroid/app/UiAutomation;", "uiDevice", "Landroidx/test/uiautomator/UiDevice;", "getUiDevice", "()Landroidx/test/uiautomator/UiDevice;", "flags", "", "kaspresso_release"})
public final class InstrumentalDependencyProviderImpl
implements InstrumentalDependencyProvider {
    @NotNull
    private final InstrumentalUsage location;
    @NotNull
    private final Instrumentation instrumentation;
    private final boolean isAndroidRuntime;

    public InstrumentalDependencyProviderImpl(@NotNull InstrumentalUsage location, @NotNull Instrumentation instrumentation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        this.location = location;
        this.instrumentation = instrumentation;
        Environment environment = EnvironmentDetectorKt.getEnvironment();
        if (environment instanceof Environment.AndroidRuntime) {
            bl = true;
        } else if (environment instanceof Environment.Robolectric) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.isAndroidRuntime = bl;
    }

    @Override
    public boolean isAndroidRuntime() {
        return this.isAndroidRuntime;
    }

    @Override
    @NotNull
    public UiDevice getUiDevice() {
        if (!this.isAndroidRuntime()) {
            throw new NotSupportedInstrumentalTestException(this.location, "UiDevice");
        }
        UiDevice uiDevice = UiDevice.getInstance((Instrumentation)this.instrumentation);
        Intrinsics.checkNotNullExpressionValue((Object)uiDevice, (String)"getInstance(instrumentation)");
        return uiDevice;
    }

    @Override
    @RequiresApi(value=24)
    @NotNull
    public UiAutomation getUiAutomation(int flags) {
        if (!this.isAndroidRuntime()) {
            throw new NotSupportedInstrumentalTestException(this.location, "UiAutomation");
        }
        UiAutomation uiAutomation = this.instrumentation.getUiAutomation(flags);
        Intrinsics.checkNotNullExpressionValue((Object)uiAutomation, (String)"instrumentation.getUiAutomation(flags)");
        return uiAutomation;
    }

    @Override
    @NotNull
    public UiAutomation getUiAutomation() {
        if (!this.isAndroidRuntime()) {
            throw new NotSupportedInstrumentalTestException(this.location, "UiAutomation");
        }
        UiAutomation uiAutomation = this.instrumentation.getUiAutomation();
        Intrinsics.checkNotNullExpressionValue((Object)uiAutomation, (String)"instrumentation.uiAutomation");
        return uiAutomation;
    }
}

