/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.interceptors.watcher.testcase.impl.logging;

import com.kaspersky.kaspresso.interceptors.watcher.testcase.StepWatcherInterceptor;
import com.kaspersky.kaspresso.internal.extensions.other.LongExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.testcases.models.info.StepInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\"\u0010\f\u001a\u00020\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/kaspersky/kaspresso/interceptors/watcher/testcase/impl/logging/LoggingStepWatcherInterceptor;", "Lcom/kaspersky/kaspresso/interceptors/watcher/testcase/StepWatcherInterceptor;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;)V", "stepStartMap", "", "Lcom/kaspersky/kaspresso/testcases/models/info/StepInfo;", "", "getStepHeader", "", "stepInfo", "getTimeReport", "stepTime", "Lkotlin/Triple;", "interceptAfterFinally", "", "interceptAfterWithError", "error", "", "interceptAfterWithSuccess", "interceptBefore", "startStepTimer", "stopStepTimerAndGetTime", "kaspresso_release"})
public final class LoggingStepWatcherInterceptor
implements StepWatcherInterceptor {
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final Map<StepInfo, Long> stepStartMap;

    public LoggingStepWatcherInterceptor(@NotNull UiTestLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        boolean bl = false;
        this.stepStartMap = new LinkedHashMap();
    }

    @Override
    public void interceptBefore(@NotNull StepInfo stepInfo) {
        Intrinsics.checkNotNullParameter((Object)stepInfo, (String)"stepInfo");
        this.startStepTimer(stepInfo);
        this.logger.header(this.getStepHeader(stepInfo));
    }

    @Override
    public void interceptAfterWithSuccess(@NotNull StepInfo stepInfo) {
        Intrinsics.checkNotNullParameter((Object)stepInfo, (String)"stepInfo");
        Triple<Long, Long, Long> stepTime = this.stopStepTimerAndGetTime(stepInfo);
        this.logger.i(this.getStepHeader(stepInfo) + " SUCCEED. " + this.getTimeReport(stepTime) + ' ');
    }

    @Override
    public void interceptAfterWithError(@NotNull StepInfo stepInfo, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)stepInfo, (String)"stepInfo");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Triple<Long, Long, Long> stepTime = this.stopStepTimerAndGetTime(stepInfo);
        this.logger.i(this.getStepHeader(stepInfo) + " FAILED. " + this.getTimeReport(stepTime) + ' ');
    }

    @Override
    public void interceptAfterFinally(@NotNull StepInfo stepInfo) {
        Intrinsics.checkNotNullParameter((Object)stepInfo, (String)"stepInfo");
        this.logger.line();
    }

    private final void startStepTimer(StepInfo stepInfo) {
        Map<StepInfo, Long> map = this.stepStartMap;
        Long l = System.currentTimeMillis();
        boolean bl = false;
        map.put(stepInfo, l);
    }

    private final Triple<Long, Long, Long> stopStepTimerAndGetTime(StepInfo stepInfo) {
        Long stepStartTime = this.stepStartMap.remove(stepInfo);
        Long l = stepStartTime;
        if (l == null) {
            throw new AssertionError((Object)"Step start timestamp was already removed");
        }
        l.longValue();
        return LongExtKt.toTime(System.currentTimeMillis() - stepStartTime);
    }

    private final String getTimeReport(Triple<Long, Long, Long> stepTime) {
        Triple<Long, Long, Long> triple = stepTime;
        long minutes = ((Number)triple.component1()).longValue();
        long secs = ((Number)triple.component2()).longValue();
        long millis = ((Number)triple.component3()).longValue();
        return "It took " + minutes + " minutes, " + secs + " seconds and " + millis + " millis.";
    }

    /*
     * WARNING - void declaration
     */
    private final String getStepHeader(StepInfo stepInfo) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("TEST STEP: \"");
        String string2 = stepInfo.getNumber();
        if (string2 == null) {
            string = "";
        } else {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl3 = false;
            String string5 = Intrinsics.stringPlus((String)it, (Object)". ");
            stringBuilder = stringBuilder2;
            String string6 = string5;
            string = string6 == null ? "" : string6;
        }
        return stringBuilder.append(string).append(stepInfo.getDescription()).append("\" in ").append(stepInfo.getTestClassName()).toString();
    }
}

