/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.internal.wait;

import com.kaspersky.kaspresso.internal.extensions.other.ThrowableExtKt;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001aa\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"wait", "T", "timeoutMs", "", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "action", "Lkotlin/Function0;", "(JLcom/kaspersky/kaspresso/logger/UiTestLogger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "allowedExceptions", "", "Ljava/lang/Class;", "", "failureMessageSource", "Lkotlin/Function1;", "", "(JLcom/kaspersky/kaspresso/logger/UiTestLogger;Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kaspresso_release"})
public final class WaitKt {
    public static final <T> T wait(long timeoutMs, @NotNull UiTestLogger logger, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        logger.i("Waiting for " + timeoutMs + " ms");
        Thread.sleep(timeoutMs);
        return (T)action.invoke();
    }

    @Nullable
    public static final <T> T wait(long timeoutMs, @NotNull UiTestLogger logger, @NotNull Set<? extends Class<? extends Throwable>> allowedExceptions, @NotNull Function1<? super Throwable, String> failureMessageSource, @Nullable Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(allowedExceptions, (String)"allowedExceptions");
        Intrinsics.checkNotNullParameter(failureMessageSource, (String)"failureMessageSource");
        logger.i("Waiting for " + timeoutMs + " ms");
        try {
            Thread.sleep(timeoutMs);
            object = action;
            object = object == null ? null : object.invoke();
        }
        catch (Throwable error) {
            if (!ThrowableExtKt.isAllowed(error, allowedExceptions)) {
                throw error;
            }
            String string = (String)failureMessageSource.invoke((Object)error);
            logger.e(string == null ? Intrinsics.stringPlus((String)"An error occurred while waiting: ", (Object)error.getClass().getSimpleName()) : string);
            object = null;
        }
        return (T)object;
    }
}

