/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.systemsafety;

import android.widget.FrameLayout;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.BySelector;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.Until;
import com.kaspersky.kaspresso.device.server.AdbServer;
import com.kaspersky.kaspresso.instrumental.InstrumentalDependencyProvider;
import com.kaspersky.kaspresso.logger.UiTestLogger;
import com.kaspersky.kaspresso.systemsafety.SystemDialogSafetyProvider;
import com.kaspersky.kaspresso.systemsafety.SystemDialogSafetyProviderImpl;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0016H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/kaspersky/kaspresso/systemsafety/SystemDialogSafetyProviderImpl;", "Lcom/kaspersky/kaspresso/systemsafety/SystemDialogSafetyProvider;", "logger", "Lcom/kaspersky/kaspresso/logger/UiTestLogger;", "instrumentalDependencyProvider", "Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;", "adbServer", "Lcom/kaspersky/kaspresso/device/server/AdbServer;", "(Lcom/kaspersky/kaspresso/logger/UiTestLogger;Lcom/kaspersky/kaspresso/instrumental/InstrumentalDependencyProvider;Lcom/kaspersky/kaspresso/device/server/AdbServer;)V", "attemptsToSuppress", "", "Lkotlin/Function2;", "Landroidx/test/uiautomator/UiDevice;", "", "uiDevice", "getUiDevice", "()Landroidx/test/uiautomator/UiDevice;", "isAndroidSystemDetected", "", "passSystemDialogs", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "suppressSystemDialogs", "R", "firstError", "", "(Ljava/lang/Throwable;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isVisible", "selector", "Landroidx/test/uiautomator/BySelector;", "timeMs", "", "Companion", "kaspresso_release"})
public final class SystemDialogSafetyProviderImpl
implements SystemDialogSafetyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiTestLogger logger;
    @NotNull
    private final InstrumentalDependencyProvider instrumentalDependencyProvider;
    @NotNull
    private final AdbServer adbServer;
    @NotNull
    private final List<Function2<UiDevice, AdbServer, Unit>> attemptsToSuppress;
    private static final long DEFAULT_TIMEOUT = 2000L;

    public SystemDialogSafetyProviderImpl(@NotNull UiTestLogger logger, @NotNull InstrumentalDependencyProvider instrumentalDependencyProvider, @NotNull AdbServer adbServer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)instrumentalDependencyProvider, (String)"instrumentalDependencyProvider");
        Intrinsics.checkNotNullParameter((Object)adbServer, (String)"adbServer");
        this.logger = logger;
        this.instrumentalDependencyProvider = instrumentalDependencyProvider;
        this.adbServer = adbServer;
        Object[] objectArray = new Function2[]{attemptsToSuppress.1.INSTANCE, attemptsToSuppress.2.INSTANCE, attemptsToSuppress.3.INSTANCE, attemptsToSuppress.4.INSTANCE, attemptsToSuppress.5.INSTANCE};
        this.attemptsToSuppress = CollectionsKt.listOf((Object[])objectArray);
    }

    private final UiDevice getUiDevice() {
        return this.instrumentalDependencyProvider.getUiDevice();
    }

    @Override
    public <T> T passSystemDialogs(@NotNull Function0<? extends T> action) throws Throwable {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            object = action.invoke();
        }
        catch (Throwable error) {
            if (this.isAndroidSystemDetected()) {
                return this.suppressSystemDialogs(error, action);
            }
            throw error;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R suppressSystemDialogs(Throwable firstError, Function0<? extends R> action) throws Throwable {
        this.logger.i("The suppressing of SystemDialogs starts");
        Throwable cachedError = null;
        cachedError = firstError;
        Iterable $this$forEachIndexed$iv = this.attemptsToSuppress;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Function2 function2 = (Function2)item$iv;
            int index = n;
            boolean bl2 = false;
            try {
                void attemptToSuppress;
                this.logger.i("The suppressing of SystemDialogs on the try #" + index + " starts");
                attemptToSuppress.invoke((Object)this.getUiDevice(), (Object)this.adbServer);
                Object result = action.invoke();
                this.logger.i(Intrinsics.stringPlus((String)"The suppressing of SystemDialogs succeeds on the try #", (Object)index));
                return (R)result;
            }
            catch (Throwable error) {
                this.logger.i("The try #" + index + " of the suppressing of SystemDialogs failed");
                cachedError = error;
                if (this.isAndroidSystemDetected()) continue;
                this.logger.i("The try #" + index + " of the suppressing of SystemDialogs failed. The reason is the error is not allowed or android system dialog is suppressed but the error is existing");
                throw cachedError;
            }
        }
        this.logger.i("The suppressing of SystemDialogs totally failed");
        throw cachedError;
    }

    private final boolean isAndroidSystemDetected() {
        UiDevice uiDevice = this.getUiDevice();
        boolean bl = false;
        boolean bl2 = false;
        UiDevice $this$isAndroidSystemDetected_u24lambda_u2d1 = uiDevice;
        boolean bl3 = false;
        BySelector bySelector = By.pkg((String)"android").clazz(FrameLayout.class);
        Intrinsics.checkNotNullExpressionValue((Object)bySelector, (String)"pkg(\"android\").clazz(FrameLayout::class.java)");
        if (SystemDialogSafetyProviderImpl.isVisible$default(this, $this$isAndroidSystemDetected_u24lambda_u2d1, bySelector, 0L, 2, null)) {
            this.logger.i("The android system dialog/window was detected");
            return true;
        }
        return false;
    }

    private final boolean isVisible(UiDevice $this$isVisible, BySelector selector, long timeMs) {
        $this$isVisible.wait(Until.findObject((BySelector)selector), timeMs);
        return $this$isVisible.findObject(selector) != null;
    }

    static /* synthetic */ boolean isVisible$default(SystemDialogSafetyProviderImpl systemDialogSafetyProviderImpl, UiDevice uiDevice, BySelector bySelector, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = TimeUnit.SECONDS.toMillis(1L);
        }
        return systemDialogSafetyProviderImpl.isVisible(uiDevice, bySelector, l);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kaspersky/kaspresso/systemsafety/SystemDialogSafetyProviderImpl$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "kaspresso_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

