/*
 * Decompiled with CFR 0.152.
 */
package com.kaspersky.kaspresso.testcases.core.step;

import com.kaspersky.kaspresso.params.StepParams;
import com.kaspersky.kaspresso.testcases.core.step.StepInfoProducer;
import com.kaspersky.kaspresso.testcases.models.StepStatus;
import com.kaspersky.kaspresso.testcases.models.info.InternalStepInfo;
import com.kaspersky.kaspresso.testcases.models.info.StepInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J,\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00032\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/kaspersky/kaspresso/testcases/core/step/StepsManager;", "Lcom/kaspersky/kaspresso/testcases/core/step/StepInfoProducer;", "testName", "", "stepParams", "Lcom/kaspersky/kaspresso/params/StepParams;", "(Ljava/lang/String;Lcom/kaspersky/kaspresso/params/StepParams;)V", "currentStepResult", "Lcom/kaspersky/kaspresso/testcases/models/info/InternalStepInfo;", "stepResultList", "", "stepsCounter", "", "testPassed", "", "checkState", "", "getAllStepsResult", "", "Lcom/kaspersky/kaspresso/testcases/models/info/StepInfo;", "onStepFinished", "stepInfo", "error", "", "produceInternalStepInfo", "description", "stepNumber", "parentStepInfo", "produceStepInfo", "kaspresso_release"})
public final class StepsManager
implements StepInfoProducer {
    @NotNull
    private final String testName;
    @NotNull
    private final StepParams stepParams;
    @NotNull
    private final List<InternalStepInfo> stepResultList;
    @Nullable
    private InternalStepInfo currentStepResult;
    private int stepsCounter;
    private boolean testPassed;

    public StepsManager(@NotNull String testName, @NotNull StepParams stepParams) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)stepParams, (String)"stepParams");
        this.testName = testName;
        this.stepParams = stepParams;
        boolean bl = false;
        this.stepResultList = new ArrayList();
    }

    @Override
    @NotNull
    public StepInfo produceStepInfo(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.checkState();
        InternalStepInfo localCurrentStep = this.currentStepResult;
        List stepNumber = null;
        InternalStepInfo stepInfo = null;
        if (localCurrentStep == null) {
            if (this.stepParams.getAutonumber()) {
                Object[] objectArray = new Integer[]{this.stepResultList.size() + 1};
                stepNumber = CollectionsKt.mutableListOf((Object[])objectArray);
            }
            this.currentStepResult = stepInfo = StepsManager.produceInternalStepInfo$default(this, description, stepNumber, null, 4, null);
            this.stepResultList.add(stepInfo);
        } else {
            if (this.stepParams.getAutonumber()) {
                boolean bl = false;
                stepNumber = new ArrayList();
                List<Integer> list = localCurrentStep.getStepNumber();
                Intrinsics.checkNotNull(list);
                stepNumber.addAll((Collection)list);
                stepNumber.add(localCurrentStep.getInternalSubStepInfos().size() + 1);
            }
            stepInfo = this.produceInternalStepInfo(description, stepNumber, localCurrentStep);
            localCurrentStep.getInternalSubStepInfos().add(stepInfo);
            this.currentStepResult = stepInfo;
        }
        return stepInfo;
    }

    @Override
    public void onStepFinished(@NotNull StepInfo stepInfo, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)stepInfo, (String)"stepInfo");
        this.checkState();
        InternalStepInfo localCurrentStepResult = this.currentStepResult;
        if (!Intrinsics.areEqual((Object)localCurrentStepResult, (Object)stepInfo)) {
            throw new IllegalStateException("Unable to finish step " + stepInfo + " cause it is not current. Current step is " + localCurrentStepResult + ". All stepInfos: " + this.stepResultList);
        }
        localCurrentStepResult.setInternalStatus(error == null ? StepStatus.SUCCESS : StepStatus.FAILED);
        localCurrentStepResult.setInternalThrowable(error);
        localCurrentStepResult.setInternalStopTime(System.currentTimeMillis());
        this.currentStepResult = localCurrentStepResult.getParentStepInfo();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StepInfo> getAllStepsResult() {
        void $this$mapTo$iv$iv;
        this.checkState();
        Throwable error = null;
        for (InternalStepInfo localCurrentStep = this.currentStepResult; localCurrentStep != null; localCurrentStep = localCurrentStep.getParentStepInfo()) {
            localCurrentStep.setInternalStatus(StepStatus.FAILED);
            if (error == null) {
                InternalStepInfo childFailedStepResult;
                Object v0;
                InternalStepInfo $this$firstOrNull$iv;
                block4: {
                    Iterable iterable = CollectionsKt.reversed((Iterable)localCurrentStep.getInternalSubStepInfos());
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        InternalStepInfo it = (InternalStepInfo)element$iv;
                        boolean bl = false;
                        if (!(it.getInternalStatus() == StepStatus.FAILED)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                $this$firstOrNull$iv = childFailedStepResult = (InternalStepInfo)v0;
                error = $this$firstOrNull$iv == null ? (Throwable)new IllegalStateException("Unable to find error to finish failed step " + localCurrentStep + ". Check all stepInfos " + this.stepResultList) : childFailedStepResult.getThrowable();
            }
            localCurrentStep.setInternalThrowable(error);
        }
        this.testPassed = true;
        Iterable $this$map$iv = this.stepResultList;
        boolean $i$f$map = false;
        Iterable $i$f$firstOrNull = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InternalStepInfo internalStepInfo = (InternalStepInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_17 = it;
            collection.add(var13_17);
        }
        return (List)destination$iv$iv;
    }

    private final void checkState() {
        if (this.testPassed) {
            throw new IllegalStateException("Please create new StepsProcessHandler object because this object consists old state.Possible reason is getAllStepsResult() calling was not after all test operations.");
        }
    }

    private final InternalStepInfo produceInternalStepInfo(String description, List<Integer> stepNumber, InternalStepInfo parentStepInfo) {
        String string = this.testName;
        List<Integer> list = stepNumber;
        String string2 = list == null ? null : CollectionsKt.joinToString$default((Iterable)list, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        StepsManager stepsManager = this;
        ++stepsManager.stepsCounter;
        int n = stepsManager.stepsCounter;
        long l = System.currentTimeMillis();
        return new InternalStepInfo(description, string, string2, n, l, stepNumber, parentStepInfo, null, null, null, 0L, 1920, null);
    }

    static /* synthetic */ InternalStepInfo produceInternalStepInfo$default(StepsManager stepsManager, String string, List list, InternalStepInfo internalStepInfo, int n, Object object) {
        if ((n & 4) != 0) {
            internalStepInfo = null;
        }
        return stepsManager.produceInternalStepInfo(string, list, internalStepInfo);
    }
}

