/*
 * Decompiled with CFR 0.152.
 */
package com.kastkode.springsandwich.filter.internal;

import com.kastkode.springsandwich.filter.annotation.After;
import com.kastkode.springsandwich.filter.annotation.AfterElement;
import com.kastkode.springsandwich.filter.annotation.Before;
import com.kastkode.springsandwich.filter.annotation.BeforeElement;
import com.kastkode.springsandwich.filter.api.AfterHandler;
import com.kastkode.springsandwich.filter.api.BeforeHandler;
import com.kastkode.springsandwich.filter.api.Flow;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class InterceptDelegator
extends HandlerInterceptorAdapter {
    @Autowired
    ApplicationContext appContext;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Before classInterceptors = handlerMethod.getMethod().getDeclaringClass().getAnnotation(Before.class);
        if (!this.preHandleInterceptors(classInterceptors, request, response, handlerMethod)) {
            return false;
        }
        Before methodInterceptors = handlerMethod.getMethod().getAnnotation(Before.class);
        if (!this.preHandleInterceptors(methodInterceptors, request, response, handlerMethod)) {
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        After classInterceptors = handlerMethod.getMethod().getDeclaringClass().getAnnotation(After.class);
        this.postHandleInterceptors(classInterceptors, request, response, handlerMethod, modelAndView);
        After methodInterceptors = handlerMethod.getMethod().getAnnotation(After.class);
        this.postHandleInterceptors(methodInterceptors, request, response, handlerMethod, modelAndView);
        super.postHandle(request, response, handler, modelAndView);
    }

    private boolean preHandleInterceptors(Before interceptors, HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        BeforeElement classWithArgs;
        BeforeHandler interceptInstance;
        if (interceptors == null) {
            return true;
        }
        Flow result = Flow.CONTINUE;
        BeforeElement[] beforeElementArray = interceptors.value();
        int n = beforeElementArray.length;
        for (int i = 0; i < n && (result = (interceptInstance = (BeforeHandler)this.appContext.getBean((classWithArgs = beforeElementArray[i]).value())).handle(request, response, handlerMethod, classWithArgs.flags())) == Flow.CONTINUE; ++i) {
        }
        return result == Flow.CONTINUE;
    }

    private void postHandleInterceptors(After interceptors, HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, ModelAndView modelAndView) throws Exception {
        if (interceptors == null) {
            return;
        }
        for (AfterElement classWithArgs : interceptors.value()) {
            AfterHandler interceptInstance = (AfterHandler)this.appContext.getBean(classWithArgs.value());
            interceptInstance.handle(request, response, handlerMethod, modelAndView, classWithArgs.flags());
        }
    }
}

