/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api;

import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.kbeanie.multipicker.api.callbacks.AudioPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenAudio;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.core.threads.AudioProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class AudioPicker
extends PickerManager {
    private static final String TAG = AudioPicker.class.getSimpleName();
    private AudioPickerCallback callback;
    private String mimeType = "audio/*";

    public AudioPicker(Activity activity) {
        super(activity, 9777);
    }

    public AudioPicker(androidx.fragment.app.Fragment fragment) {
        super(fragment, 9777);
    }

    public AudioPicker(Fragment appFragment) {
        super(appFragment, 9777);
    }

    public void setAudioPickerCallback(AudioPickerCallback callback) {
        this.callback = callback;
    }

    public void allowMultiple() {
        this.allowMultiple = true;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void pickAudio() {
        block2: {
            try {
                this.pick();
            }
            catch (PickerException e) {
                e.printStackTrace();
                if (this.callback == null) break block2;
                this.callback.onError(e.getMessage());
            }
        }
    }

    @Override
    protected String pick() throws PickerException {
        if (this.callback == null) {
            throw new PickerException("AudioPickerCallback is null!!! Please set one");
        }
        String action = "android.intent.action.GET_CONTENT";
        Intent intent = new Intent(action);
        intent.setType(this.mimeType);
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        intent.addFlags(1);
        intent.addCategory("android.intent.category.OPENABLE");
        this.pickInternal(intent, this.pickerType);
        return null;
    }

    @Override
    public void submit(Intent data) {
        this.handleAudioData(data);
    }

    private void handleAudioData(Intent intent) {
        ArrayList<String> uris = new ArrayList<String>();
        if (intent != null) {
            int i;
            if (intent.getDataString() != null) {
                String uri = intent.getDataString();
                LogUtils.d(TAG, "handleAudioData: " + uri);
                uris.add(uri);
            } else if (Build.VERSION.SDK_INT >= 16 && intent.getClipData() != null) {
                ClipData clipData = intent.getClipData();
                LogUtils.d(TAG, "handleAudioData: Multiple audios with ClipData");
                for (i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    LogUtils.d(TAG, "Item [" + i + "]: " + item.getUri().toString());
                    uris.add(item.getUri().toString());
                }
            }
            if (intent.hasExtra("uris")) {
                ArrayList paths = intent.getParcelableArrayListExtra("uris");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
            this.processFiles(uris);
        }
    }

    private void processFiles(List<String> uris) {
        AudioProcessorThread thread = new AudioProcessorThread(this.getContext(), this.getFileObjects(uris), this.cacheLocation);
        thread.setRequestId(this.requestId);
        thread.setAudioPickerCallback(this.callback);
        thread.start();
    }

    private void onError(final String errorMessage) {
        try {
            if (this.callback != null) {
                ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AudioPicker.this.callback.onError(errorMessage);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private List<ChosenFile> getFileObjects(List<String> uris) {
        ArrayList<ChosenFile> files = new ArrayList<ChosenFile>();
        for (String uri : uris) {
            ChosenAudio audio = new ChosenAudio();
            audio.setQueryUri(uri);
            audio.setDirectoryType(Environment.DIRECTORY_MUSIC);
            audio.setType("audio");
            files.add(audio);
        }
        return files;
    }
}

