/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;
import com.kbeanie.multipicker.api.callbacks.ContactPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenContact;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.utils.LogUtils;

public class ContactPicker
extends PickerManager {
    private static final String TAG = ContactPicker.class.getSimpleName();
    private ContactPickerCallback callback;

    public ContactPicker(Activity activity) {
        super(activity, 8666);
    }

    public ContactPicker(androidx.fragment.app.Fragment fragment) {
        super(fragment, 8666);
    }

    public ContactPicker(Fragment appFragment) {
        super(appFragment, 8666);
    }

    public void setContactPickerCallback(ContactPickerCallback callback) {
        this.callback = callback;
    }

    public void pickContact() {
        block2: {
            try {
                this.checkPermission();
                this.pick();
            }
            catch (PickerException e) {
                e.printStackTrace();
                if (this.callback == null) break block2;
                this.callback.onError(e.getMessage());
            }
        }
    }

    @Override
    protected String pick() throws PickerException {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("vnd.android.cursor.dir/contact");
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        this.pickInternal(intent, 8666);
        return null;
    }

    @Override
    public void submit(Intent data) {
        if (data != null && data.getData() != null && data.getData() instanceof Uri) {
            Uri uri = data.getData();
            LogUtils.d(TAG, "submit: " + uri);
            this.queryForContact(uri);
        }
    }

    private int getRawContactId(int contactId) {
        int rawContactId = -1;
        String[] projection = new String[]{"_id"};
        String selection = "contact_id = ?";
        String[] selectionArgs = new String[]{contactId + ""};
        Cursor cursor = this.getContext().getContentResolver().query(ContactsContract.RawContacts.CONTENT_URI, projection, selection, selectionArgs, null);
        if (cursor != null && cursor.getCount() > 0) {
            if (cursor.moveToFirst()) {
                rawContactId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            }
            cursor.close();
        }
        return rawContactId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryForContact(Uri uri) {
        int rawContactId;
        String[] projection = new String[]{"display_name", "photo_uri", "_id"};
        ChosenContact contact = new ChosenContact();
        contact.setRequestId(this.requestId);
        Cursor cursor = this.getContext().getContentResolver().query(uri, projection, null, null, null);
        int contactId = 0;
        if (cursor.moveToFirst()) {
            contactId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            String displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
            String photoUri = cursor.getString(cursor.getColumnIndexOrThrow("photo_uri"));
            contact.setDisplayName(displayName);
            contact.setPhotoUri(photoUri);
        }
        if ((rawContactId = this.getRawContactId(contactId)) != -1) {
            String selection = "raw_contact_id = ?";
            String[] selectionArgs = new String[]{rawContactId + ""};
            try (Cursor rawContactCursor = this.getContext().getContentResolver().query(ContactsContract.Data.CONTENT_URI, new String[]{"mimetype", "data1"}, selection, selectionArgs, null);){
                while (rawContactCursor.moveToNext()) {
                    String mimeType = rawContactCursor.getString(0);
                    String data = rawContactCursor.getString(1);
                    if (mimeType.equals("vnd.android.cursor.item/name")) {
                        contact.setDisplayName(data);
                    }
                    if (mimeType.equals("vnd.android.cursor.item/phone_v2")) {
                        contact.addPhone(data);
                    }
                    if (!mimeType.equals("vnd.android.cursor.item/email_v2")) continue;
                    contact.addEmail(data);
                }
            }
            cursor.close();
            try {
                if (this.callback != null) {
                    this.callback.onContactChosen(contact);
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            this.callback.onError("Contact Not found - Error - Please report to developer");
        }
    }

    private void checkPermission() {
        boolean permissionGranted = this.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") == 0;
        LogUtils.d(TAG, "checkIfPermissionsAvailable: In Manifest(READ_CONTACTS): " + permissionGranted);
        if (!permissionGranted) {
            Log.e((String)TAG, (String)"android.permission.READ_CONTACTS permission is missing in manifest file");
            throw new RuntimeException("Permissions missing in Manifest");
        }
    }
}

