/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api;

import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.kbeanie.multipicker.api.callbacks.FilePickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.core.threads.FileProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class FilePicker
extends PickerManager {
    private static final String TAG = FilePicker.class.getSimpleName();
    private FilePickerCallback callback;
    private String mimeType = "*/*";

    public FilePicker(Activity activity) {
        super(activity, 7555);
    }

    public FilePicker(androidx.fragment.app.Fragment fragment) {
        super(fragment, 7555);
    }

    public FilePicker(Fragment appFragment) {
        super(appFragment, 7555);
    }

    public void allowMultiple() {
        this.allowMultiple = true;
    }

    public void setFilePickerCallback(FilePickerCallback callback) {
        this.callback = callback;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void pickFile() {
        block2: {
            try {
                this.pick();
            }
            catch (PickerException e) {
                e.printStackTrace();
                if (this.callback == null) break block2;
                this.callback.onError(e.getMessage());
            }
        }
    }

    @Override
    protected String pick() throws PickerException {
        if (this.callback == null) {
            throw new PickerException("FilePickerCallback is null!!! Please set one");
        }
        String action = "android.intent.action.GET_CONTENT";
        Intent intent = new Intent(action);
        intent.setType(this.mimeType);
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        intent.addFlags(1);
        intent.addCategory("android.intent.category.OPENABLE");
        this.pickInternal(intent, this.pickerType);
        return null;
    }

    @Override
    public void submit(Intent data) {
        this.handleFileData(data);
    }

    private void handleFileData(Intent intent) {
        ArrayList<String> uris = new ArrayList<String>();
        if (intent != null) {
            int i;
            if (intent.getDataString() != null) {
                String uri = intent.getDataString();
                LogUtils.d(TAG, "handleFileData: " + uri);
                uris.add(uri);
            } else if (Build.VERSION.SDK_INT >= 16 && intent.getClipData() != null) {
                ClipData clipData = intent.getClipData();
                LogUtils.d(TAG, "handleFileData: Multiple files with ClipData");
                for (i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    LogUtils.d(TAG, "Item [" + i + "]: " + item.getUri().toString());
                    uris.add(item.getUri().toString());
                }
            }
            if (intent.hasExtra("uris")) {
                ArrayList paths = intent.getParcelableArrayListExtra("uris");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
            this.processFiles(uris);
        }
    }

    private void processFiles(List<String> uris) {
        FileProcessorThread thread = new FileProcessorThread(this.getContext(), this.getFileObjects(uris), this.cacheLocation);
        thread.setFilePickerCallback(this.callback);
        thread.setRequestId(this.requestId);
        thread.start();
    }

    private void onError(final String errorMessage) {
        try {
            if (this.callback != null) {
                ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FilePicker.this.callback.onError(errorMessage);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private List<ChosenFile> getFileObjects(List<String> uris) {
        ArrayList<ChosenFile> files = new ArrayList<ChosenFile>();
        for (String uri : uris) {
            ChosenFile file = new ChosenFile();
            file.setQueryUri(uri);
            if (Build.VERSION.SDK_INT >= 19) {
                file.setDirectoryType(Environment.DIRECTORY_DOCUMENTS);
            } else {
                file.setDirectoryType(Environment.DIRECTORY_DOWNLOADS);
            }
            file.setType("file");
            files.add(file);
        }
        return files;
    }
}

