/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.kbeanie.multipicker.api.callbacks.FilePickerCallback;
import com.kbeanie.multipicker.api.callbacks.ImagePickerCallback;
import com.kbeanie.multipicker.api.callbacks.MediaPickerCallback;
import com.kbeanie.multipicker.api.callbacks.VideoPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.kbeanie.multipicker.api.entity.ChosenVideo;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.core.threads.FileProcessorThread;
import com.kbeanie.multipicker.core.threads.ImageProcessorThread;
import com.kbeanie.multipicker.core.threads.VideoProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MediaPicker
extends PickerManager
implements FilePickerCallback,
ImagePickerCallback,
VideoPickerCallback {
    private static final String TAG = MediaPicker.class.getSimpleName();
    private MediaPickerCallback callback;
    private boolean generateThumbnails = true;
    private boolean generateMetadata = true;
    private boolean generatePreviewImages = true;
    private List<ChosenImage> imagesToProcess;
    private List<ChosenVideo> videosToProcess;
    private List<ChosenImage> images;
    private List<ChosenVideo> videos;

    public MediaPicker(Activity activity) {
        super(activity, 10888);
    }

    public MediaPicker(androidx.fragment.app.Fragment fragment) {
        super(fragment, 10888);
    }

    public MediaPicker(Fragment appFragment) {
        super(appFragment, 10888);
    }

    public void allowMultiple() {
        this.allowMultiple = true;
    }

    public void shouldGenerateThumbnails(boolean generateThumbnails) {
        this.generateThumbnails = generateThumbnails;
    }

    public void shouldGenerateMetadata(boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public void shouldGeneratePreviewImages(boolean generatePreviewImages) {
        this.generatePreviewImages = generatePreviewImages;
    }

    @Override
    protected String pick() throws PickerException {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        if (Build.VERSION.SDK_INT >= 19) {
            intent.setType("*/*");
            String[] mimeTypes = new String[]{"image/*", "video/*"};
            intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
        } else {
            intent.setType("image/*, video/*");
        }
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        intent.addFlags(1);
        this.pickInternal(intent, 10888);
        return null;
    }

    public void pickMedia() {
        try {
            this.pick();
        }
        catch (PickerException e) {
            e.printStackTrace();
        }
    }

    @Override
    @TargetApi(value=16)
    public void submit(Intent intent) {
        ArrayList<String> uris = new ArrayList<String>();
        if (intent != null) {
            ArrayList paths;
            int i;
            if (intent.getDataString() != null && this.isClipDataApi() && intent.getClipData() == null) {
                String uri = intent.getDataString();
                LogUtils.d(TAG, "submit: Uri: " + uri);
                uris.add(uri);
            } else if (this.isClipDataApi() && intent.getClipData() != null) {
                ClipData clipData = intent.getClipData();
                for (i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    LogUtils.d(TAG, "Item [" + i + "]: " + item.getUri().toString());
                    uris.add(item.getUri().toString());
                }
            }
            if (intent.hasExtra("uris")) {
                paths = intent.getParcelableArrayListExtra("uris");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
            if (uris.size() == 0 && intent.hasExtra("pick-result-data")) {
                paths = intent.getParcelableArrayListExtra("pick-result-data");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
        }
        this.processMedia(uris);
    }

    private void processMedia(List<String> uris) {
        FileProcessorThread thread = new FileProcessorThread(this.getContext(), this.getFileObjects(uris), this.cacheLocation);
        thread.setFilePickerCallback(this);
        thread.setRequestId(this.requestId);
        thread.start();
    }

    public void setMediaPickerCallback(MediaPickerCallback callback) {
        this.callback = callback;
    }

    private List<ChosenFile> getFileObjects(List<String> uris) {
        ArrayList<ChosenFile> files = new ArrayList<ChosenFile>();
        for (String uri : uris) {
            ChosenFile file = new ChosenFile();
            file.setQueryUri(uri);
            if (Build.VERSION.SDK_INT >= 19) {
                file.setDirectoryType(Environment.DIRECTORY_DOCUMENTS);
            } else {
                file.setDirectoryType(Environment.DIRECTORY_DOWNLOADS);
            }
            file.setType("file");
            files.add(file);
        }
        return files;
    }

    @Override
    public void onFilesChosen(List<ChosenFile> files) {
        this.imagesToProcess = new ArrayList<ChosenImage>();
        this.videosToProcess = new ArrayList<ChosenVideo>();
        for (ChosenFile file : files) {
            if (file.getMimeType().contains("image")) {
                ChosenImage image = new ChosenImage();
                image.setQueryUri(Uri.fromFile((File)new File(file.getOriginalPath())).toString());
                image.setType("image");
                image.setDirectoryType(Environment.DIRECTORY_PICTURES);
                image.setDisplayName(file.getDisplayName());
                image.setExtension(file.getExtension());
                this.imagesToProcess.add(image);
                continue;
            }
            if (!file.getMimeType().contains("video")) continue;
            ChosenVideo video = new ChosenVideo();
            video.setQueryUri(Uri.fromFile((File)new File(file.getOriginalPath())).toString());
            video.setType("video");
            video.setDirectoryType(Environment.DIRECTORY_MOVIES);
            video.setDisplayName(file.getDisplayName());
            video.setExtension(file.getExtension());
            this.videosToProcess.add(video);
        }
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            ImageProcessorThread imgThread = new ImageProcessorThread(this.getContext(), this.imagesToProcess, this.cacheLocation);
            imgThread.setImagePickerCallback(this);
            imgThread.setShouldGenerateMetadata(this.generateMetadata);
            imgThread.setShouldGenerateThumbnails(this.generateThumbnails);
            imgThread.setRequestId(this.requestId);
            imgThread.start();
        } else if (this.videosToProcess != null && this.videosToProcess.size() > 0) {
            VideoProcessorThread vidThread = new VideoProcessorThread(this.getContext(), this.videosToProcess, this.cacheLocation);
            vidThread.setRequestId(this.requestId);
            vidThread.setShouldGenerateMetadata(this.generateMetadata);
            vidThread.setShouldGeneratePreviewImages(this.generatePreviewImages);
            vidThread.setVideoPickerCallback(this);
            vidThread.start();
        }
    }

    @Override
    public void onError(String message) {
    }

    @Override
    public void onImagesChosen(List<ChosenImage> images) {
        this.images = images;
        if (this.videosToProcess != null && this.videosToProcess.size() > 0) {
            VideoProcessorThread vidThread = new VideoProcessorThread(this.getContext(), this.videosToProcess, this.cacheLocation);
            vidThread.setRequestId(this.requestId);
            vidThread.setShouldGenerateMetadata(this.generateMetadata);
            vidThread.setShouldGeneratePreviewImages(this.generatePreviewImages);
            vidThread.setVideoPickerCallback(this);
            vidThread.start();
        } else if (this.callback != null) {
            this.callback.onMediaChosen(images, null);
        }
    }

    @Override
    public void onVideosChosen(List<ChosenVideo> videos) {
        this.videos = videos;
        if (this.callback != null) {
            this.callback.onMediaChosen(this.images, videos);
        }
    }
}

