/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api.entity;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class ChosenContact
implements Parcelable {
    private static final String FORMAT_CONTACT = "Name: %s, Photo: %s, Phones: %s, Emails: %s";
    private String displayName;
    private String photoUri;
    private final List<String> phones;
    private final List<String> emails;
    private int requestId;
    public static final Parcelable.Creator<ChosenContact> CREATOR = new Parcelable.Creator<ChosenContact>(){

        public ChosenContact createFromParcel(Parcel in) {
            return new ChosenContact(in);
        }

        public ChosenContact[] newArray(int size) {
            return new ChosenContact[size];
        }
    };

    protected ChosenContact(Parcel in) {
        this.displayName = in.readString();
        this.photoUri = in.readString();
        this.phones = in.createStringArrayList();
        this.emails = in.createStringArrayList();
        this.requestId = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.displayName);
        dest.writeString(this.photoUri);
        dest.writeStringList(this.phones);
        dest.writeStringList(this.emails);
        dest.writeInt(this.requestId);
    }

    public ChosenContact() {
        this.phones = new ArrayList<String>();
        this.emails = new ArrayList<String>();
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPhotoUri() {
        return this.photoUri;
    }

    public void setPhotoUri(String photoUri) {
        this.photoUri = photoUri;
    }

    public void addPhone(String phone) {
        this.phones.add(phone);
    }

    public List<String> getPhones() {
        return this.phones;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public void addEmail(String email) {
        this.emails.add(email);
    }

    public String toString() {
        return String.format(FORMAT_CONTACT, this.displayName, this.photoUri, this.getPhonesString(), this.getEmailsString());
    }

    private String getEmailsString() {
        String emailsString = "";
        for (String email : this.emails) {
            emailsString = emailsString + "[" + email + "]";
        }
        return emailsString;
    }

    private String getPhonesString() {
        String phonesString = "";
        for (String phone : this.phones) {
            phonesString = phonesString + "[" + phone + "]";
        }
        return phonesString;
    }

    public int describeContents() {
        return 0;
    }
}

