/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api.entity;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class ChosenFile
implements Parcelable {
    private long id;
    private String queryUri;
    private String originalPath;
    private String mimeType;
    private long size;
    private String extension;
    private Date createdAt;
    private String type;
    private int requestId;
    private String displayName;
    private boolean success;
    private String tempFile = "";
    public static final Parcelable.Creator<ChosenFile> CREATOR = new Parcelable.Creator<ChosenFile>(){

        public ChosenFile createFromParcel(Parcel in) {
            return new ChosenFile(in);
        }

        public ChosenFile[] newArray(int size) {
            return new ChosenFile[size];
        }
    };
    private String directoryType;
    private static final String STRING_FORMAT = "Type: %s, QueryUri: %s, Original Path: %s, MimeType: %s, Size: %s";

    public ChosenFile() {
    }

    protected ChosenFile(Parcel in) {
        this.id = in.readLong();
        this.queryUri = in.readString();
        this.originalPath = in.readString();
        this.mimeType = in.readString();
        this.size = in.readLong();
        this.extension = in.readString();
        this.createdAt = new Date(in.readLong());
        this.type = in.readString();
        this.displayName = in.readString();
        this.success = in.readByte() != 0;
        this.directoryType = in.readString();
        this.requestId = in.readInt();
        this.tempFile = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.queryUri);
        dest.writeString(this.originalPath);
        dest.writeString(this.mimeType);
        dest.writeLong(this.size);
        dest.writeString(this.extension);
        dest.writeLong(this.createdAt.getTime());
        dest.writeString(this.type);
        dest.writeString(this.displayName);
        dest.writeInt(this.success ? 1 : 0);
        dest.writeString(this.directoryType);
        dest.writeInt(this.requestId);
        dest.writeString(this.tempFile);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public long getId() {
        return this.id;
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getQueryUri() {
        return this.queryUri;
    }

    public void setQueryUri(String queryUri) {
        this.queryUri = queryUri;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFileExtensionFromMimeType() {
        String[] parts;
        String extension = "";
        if (this.mimeType != null && (parts = this.mimeType.split("/")).length >= 2 && !parts[1].equals("*")) {
            extension = "." + parts[1];
        }
        return extension;
    }

    public String getFileExtensionFromMimeTypeWithoutDot() {
        return this.getFileExtensionFromMimeType().replace(".", "");
    }

    public String toString() {
        return String.format(STRING_FORMAT, this.type, this.queryUri, this.originalPath, this.mimeType, this.getHumanReadableSize(false));
    }

    public String getHumanReadableSize(boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (this.size < (long)unit) {
            return this.size + " B";
        }
        int exp = (int)(Math.log(this.size) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + "";
        return String.format(Locale.ENGLISH, "%.1f %sB", (double)this.size / Math.pow(unit, exp), pre);
    }

    public String getHumanReadableDuration(long duration) {
        return String.format(Locale.getDefault(), "%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(duration), TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration)), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public int describeContents() {
        return 0;
    }

    public String getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(String tempFile) {
        this.tempFile = tempFile;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChosenFile)) {
            return false;
        }
        ChosenFile other = (ChosenFile)obj;
        String otherString = other.getIdString();
        String thisString = this.getIdString();
        return otherString.equals(thisString);
    }

    public int hashCode() {
        return this.getIdString().hashCode();
    }

    private String getIdString() {
        return this.queryUri + ":" + this.originalPath + ":" + this.mimeType + ":" + this.size;
    }
}

