/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api.entity;

import android.os.Parcel;
import android.os.Parcelable;
import com.kbeanie.multipicker.api.entity.ChosenFile;

public class ChosenImage
extends ChosenFile {
    private int orientation;
    private String thumbnailPath;
    private String thumbnailSmallPath;
    private int width;
    private int height;
    public static final Parcelable.Creator<ChosenImage> CREATOR = new Parcelable.Creator<ChosenImage>(){

        public ChosenImage createFromParcel(Parcel in) {
            return new ChosenImage(in);
        }

        public ChosenImage[] newArray(int size) {
            return new ChosenImage[size];
        }
    };
    private static final String STRING_FORMAT = "Height: %s, Width: %s, Orientation: %s";

    public ChosenImage() {
    }

    protected ChosenImage(Parcel in) {
        super(in);
        this.orientation = in.readInt();
        this.thumbnailPath = in.readString();
        this.thumbnailSmallPath = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public String getThumbnailPath() {
        return this.thumbnailPath;
    }

    public void setThumbnailPath(String thumbnailPath) {
        this.thumbnailPath = thumbnailPath;
    }

    public String getThumbnailSmallPath() {
        return this.thumbnailSmallPath;
    }

    public void setThumbnailSmallPath(String thumbnailSmallPath) {
        this.thumbnailSmallPath = thumbnailSmallPath;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.format(STRING_FORMAT, this.height, this.width, this.getOrientationName());
    }

    public String getOrientationName() {
        String orientationName = "NORMAL";
        switch (this.orientation) {
            case 2: {
                orientationName = "FLIP_HORIZONTAL";
                break;
            }
            case 4: {
                orientationName = "FLIP_VERTICAL";
                break;
            }
            case 6: {
                orientationName = "ROTATE_90";
                break;
            }
            case 3: {
                orientationName = "ROTATE_180";
                break;
            }
            case 8: {
                orientationName = "ROTATE_270";
                break;
            }
            case 5: {
                orientationName = "TRANSPOSE";
                break;
            }
            case 7: {
                orientationName = "TRANSVERSE";
                break;
            }
            case 0: {
                orientationName = "UNDEFINED";
            }
        }
        return orientationName;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.orientation);
        dest.writeString(this.thumbnailPath);
        dest.writeString(this.thumbnailSmallPath);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
    }
}

