/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import androidx.appcompat.app.AppCompatActivity;
import com.kbeanie.multipicker.api.CameraImagePicker;
import com.kbeanie.multipicker.api.ImagePicker;
import com.kbeanie.multipicker.api.callbacks.ImagePickerCallback;
import com.kbeanie.multipicker.core.ImagePickerImpl;

public abstract class PickImageActivity
extends AppCompatActivity
implements ImagePickerCallback {
    private ImagePicker imagePicker;
    private CameraImagePicker cameraImagePicker;
    private int pickerType;
    private String pickerPath;

    protected void pickSingleImage() {
        this.imagePicker = this.prepareImagePicker();
        this.imagePicker.pickImage();
        this.pickerType = 3111;
    }

    protected void pickMultipleImages() {
        this.imagePicker = this.prepareImagePicker();
        this.imagePicker.allowMultiple();
        this.imagePicker.pickImage();
        this.pickerType = 3111;
    }

    protected void pickImageFromCamera() {
        this.cameraImagePicker = this.prepareCameraImagePicker();
        this.pickerPath = this.cameraImagePicker.pickImage();
        this.pickerType = 4222;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && (requestCode == 4222 || requestCode == 3111)) {
            ImagePickerImpl imagePickerImpl = null;
            if (this.pickerType == 3111) {
                if (this.imagePicker == null) {
                    this.imagePicker = this.prepareImagePicker();
                }
                imagePickerImpl = this.imagePicker;
            } else if (this.pickerType == 4222) {
                if (this.cameraImagePicker == null) {
                    this.cameraImagePicker = this.prepareCameraImagePicker();
                    this.cameraImagePicker.reinitialize(this.pickerPath);
                }
                imagePickerImpl = this.cameraImagePicker;
            }
            imagePickerImpl.submit(data);
        }
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        outState.putInt("mpl_picker_type", this.pickerType);
        outState.putString("mpl_picker_path", this.pickerPath);
        super.onSaveInstanceState(outState, outPersistentState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.pickerType = savedInstanceState.getInt("mpl_picker_type");
        this.pickerPath = savedInstanceState.getString("mpl_picker_path");
    }

    private ImagePicker prepareImagePicker() {
        ImagePicker imagePicker = new ImagePicker((Activity)this);
        imagePicker.setImagePickerCallback(this);
        return imagePicker;
    }

    private CameraImagePicker prepareCameraImagePicker() {
        CameraImagePicker imagePicker = new CameraImagePicker((Activity)this);
        imagePicker.setImagePickerCallback(this);
        return imagePicker;
    }
}

