/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.api.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import androidx.appcompat.app.AppCompatActivity;
import com.kbeanie.multipicker.api.CameraVideoPicker;
import com.kbeanie.multipicker.api.VideoPicker;
import com.kbeanie.multipicker.api.callbacks.VideoPickerCallback;
import com.kbeanie.multipicker.core.VideoPickerImpl;

public abstract class PickVideoActivity
extends AppCompatActivity
implements VideoPickerCallback {
    private VideoPicker videoPicker;
    private CameraVideoPicker cameraVideoPicker;
    private int pickerType;
    private String pickerPath;

    protected void pickSingleVideo() {
        this.videoPicker = this.prepareVideoPicker();
        this.videoPicker.pickVideo();
        this.pickerType = 5333;
    }

    protected void pickMultipleVideos() {
        this.videoPicker = this.prepareVideoPicker();
        this.videoPicker.allowMultiple();
        this.videoPicker.pickVideo();
        this.pickerType = 5333;
    }

    protected void pickVideoFromCamera() {
        this.cameraVideoPicker = this.prepareCameraVideoPicker();
        this.pickerPath = this.cameraVideoPicker.pickVideo();
        this.pickerType = 6444;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && (requestCode == 6444 || requestCode == 5333)) {
            VideoPickerImpl videoPickerImpl = null;
            if (this.pickerType == 5333) {
                if (this.videoPicker == null) {
                    this.videoPicker = this.prepareVideoPicker();
                }
                videoPickerImpl = this.videoPicker;
            } else if (this.pickerType == 6444) {
                if (this.cameraVideoPicker == null) {
                    this.cameraVideoPicker = this.prepareCameraVideoPicker();
                    this.cameraVideoPicker.reinitialize(this.pickerPath);
                }
                videoPickerImpl = this.cameraVideoPicker;
            }
            videoPickerImpl.submit(data);
        }
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        outState.putInt("mpl_picker_type", this.pickerType);
        outState.putString("mpl_picker_path", this.pickerPath);
        super.onSaveInstanceState(outState, outPersistentState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.pickerType = savedInstanceState.getInt("mpl_picker_type");
        this.pickerPath = savedInstanceState.getString("mpl_picker_path");
    }

    private VideoPicker prepareVideoPicker() {
        VideoPicker videoPicker = new VideoPicker((Activity)this);
        videoPicker.setVideoPickerCallback(this);
        return videoPicker;
    }

    private CameraVideoPicker prepareCameraVideoPicker() {
        CameraVideoPicker imagePicker = new CameraVideoPicker((Activity)this);
        imagePicker.setVideoPickerCallback(this);
        return imagePicker;
    }
}

