/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.kbeanie.multipicker.api.callbacks.ImagePickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.core.threads.ImageProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class ImagePickerImpl
extends PickerManager {
    private static final String TAG = ImagePickerImpl.class.getSimpleName();
    private String path;
    private boolean generateThumbnails = true;
    private boolean generateMetadata = true;
    private int quality = 100;
    private int maxWidth = -1;
    private int maxHeight = -1;
    protected ImagePickerCallback callback;

    public ImagePickerImpl(Activity activity, int pickerType) {
        super(activity, pickerType);
    }

    public ImagePickerImpl(androidx.fragment.app.Fragment fragment, int pickerType) {
        super(fragment, pickerType);
    }

    public ImagePickerImpl(Fragment appFragment, int pickerType) {
        super(appFragment, pickerType);
    }

    public void shouldGenerateThumbnails(boolean generateThumbnails) {
        this.generateThumbnails = generateThumbnails;
    }

    public void shouldGenerateMetadata(boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public void reinitialize(String path) {
        this.path = path;
    }

    public void setImagePickerCallback(ImagePickerCallback callback) {
        this.callback = callback;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void ensureMaxSize(int width, int height) {
        if (width > 0 && height > 0) {
            this.maxWidth = width;
            this.maxHeight = height;
        }
    }

    @Override
    protected String pick() throws PickerException {
        if (this.callback == null) {
            throw new PickerException("ImagePickerCallback is null!!! Please set one.");
        }
        if (this.pickerType == 3111) {
            return this.pickLocalImage();
        }
        if (this.pickerType == 4222) {
            this.path = this.takePictureWithCamera();
            return this.path;
        }
        return null;
    }

    protected String pickLocalImage() {
        Intent intent;
        if (Build.VERSION.SDK_INT >= 19) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", false);
            intent.addFlags(64);
        } else {
            intent = new Intent("android.intent.action.GET_CONTENT");
        }
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        intent.setType("image/*");
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        intent.addFlags(1);
        this.pickInternal(intent, 3111);
        return null;
    }

    protected String takePictureWithCamera() throws PickerException {
        String tempFilePath;
        Uri uri = null;
        if (Build.VERSION.SDK_INT >= 24 || this.cacheLocation == 400) {
            tempFilePath = this.getNewFileLocation("jpeg", Environment.DIRECTORY_PICTURES);
            File file = new File(tempFilePath);
            uri = FileProvider.getUriForFile((Context)this.getContext(), (String)this.getFileProviderAuthority(), (File)file);
            LogUtils.d(TAG, "takeVideoWithCamera: Temp Uri: " + uri.getPath());
        } else {
            tempFilePath = this.buildFilePath("jpeg", Environment.DIRECTORY_PICTURES);
            uri = Uri.fromFile((File)new File(tempFilePath));
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        LogUtils.d(TAG, "Temp Path for Camera capture: " + tempFilePath);
        this.pickInternal(intent, 4222);
        return tempFilePath;
    }

    @Override
    public void submit(Intent data) {
        if (this.pickerType == 4222) {
            this.handleCameraData(data);
        } else if (this.pickerType == 3111) {
            this.handleGalleryData(data);
        }
    }

    private void handleCameraData(Intent data) {
        LogUtils.d(TAG, "handleCameraData: " + this.path);
        if (this.path == null || this.path.isEmpty()) {
            throw new RuntimeException("Camera Path cannot be null. Re-initialize with correct path value.");
        }
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(Uri.fromFile((File)new File(this.path)).toString());
        this.processImages(uris);
    }

    @SuppressLint(value={"NewApi"})
    private void handleGalleryData(Intent intent) {
        ArrayList<String> uris = new ArrayList<String>();
        if (intent != null) {
            int i;
            if (intent.getDataString() != null && this.isClipDataApi() && intent.getClipData() == null) {
                String uri = intent.getDataString();
                LogUtils.d(TAG, "handleGalleryData: " + uri);
                uris.add(uri);
            } else if (this.isClipDataApi() && intent.getClipData() != null) {
                ClipData clipData = intent.getClipData();
                LogUtils.d(TAG, "handleGalleryData: Multiple images with ClipData");
                for (i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    LogUtils.d(TAG, "Item [" + i + "]: " + item.getUri().toString());
                    uris.add(item.getUri().toString());
                }
            }
            if (intent.hasExtra("uris")) {
                ArrayList paths = intent.getParcelableArrayListExtra("uris");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
            this.processImages(uris);
        }
    }

    private void onError(final String errorMessage) {
        try {
            if (this.callback != null) {
                ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ImagePickerImpl.this.callback.onError(errorMessage);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void processImages(List<String> uris) {
        ImageProcessorThread thread = new ImageProcessorThread(this.getContext(), this.getImageObjects(uris), this.cacheLocation);
        if (this.maxWidth != -1 && this.maxHeight != -1) {
            thread.setOutputImageDimensions(this.maxWidth, this.maxHeight);
        }
        thread.setRequestId(this.requestId);
        thread.setShouldGenerateThumbnails(this.generateThumbnails);
        thread.setShouldGenerateMetadata(this.generateMetadata);
        thread.setOutputImageQuality(this.quality);
        thread.setImagePickerCallback(this.callback);
        thread.start();
    }

    private List<ChosenImage> getImageObjects(List<String> uris) {
        ArrayList<ChosenImage> images = new ArrayList<ChosenImage>();
        for (String uri : uris) {
            ChosenImage image = new ChosenImage();
            image.setQueryUri(uri);
            image.setDirectoryType(Environment.DIRECTORY_PICTURES);
            image.setType("image");
            images.add(image);
        }
        return images;
    }
}

