/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.utils.FileUtils;
import com.kbeanie.multipicker.utils.LogUtils;
import java.io.File;
import java.util.UUID;
import storage.StoragePreferences;

public abstract class PickerManager {
    private static final String TAG = PickerManager.class.getSimpleName();
    protected Activity activity;
    protected androidx.fragment.app.Fragment fragment;
    protected Fragment appFragment;
    public static boolean debugglable;
    protected final int pickerType;
    protected int requestId;
    protected int cacheLocation = 100;
    protected Bundle extras;
    protected boolean allowMultiple;

    public PickerManager(Activity activity, int pickerType) {
        this.activity = activity;
        this.pickerType = pickerType;
        this.initProperties();
    }

    public PickerManager(androidx.fragment.app.Fragment fragment, int pickerType) {
        this.fragment = fragment;
        this.pickerType = pickerType;
        this.initProperties();
    }

    public PickerManager(Fragment appFragment, int pickerType) {
        this.appFragment = appFragment;
        this.pickerType = pickerType;
        this.initProperties();
    }

    private void initProperties() {
        debugglable = new StoragePreferences(this.getContext()).isDebuggable();
    }

    public void setExtras(Bundle extras) {
        this.extras = extras;
    }

    public void setCacheLocation(int cacheLocation) {
        this.cacheLocation = cacheLocation;
        if (cacheLocation == 100) {
            this.checkIfPermissionsAvailable();
        }
    }

    @Deprecated
    public void setFolderName(String folderName) {
        StoragePreferences preferences = new StoragePreferences(this.getContext());
        preferences.setFolderName(folderName);
    }

    protected abstract String pick() throws PickerException;

    public abstract void submit(Intent var1);

    protected String buildFilePath(String extension, String type) throws PickerException {
        String directoryPath = this.getDirectory(type);
        return directoryPath + File.separator + UUID.randomUUID().toString() + "." + extension;
    }

    protected String getDirectory(String type) throws PickerException {
        String directory = null;
        switch (this.cacheLocation) {
            case 100: {
                directory = FileUtils.getExternalFilesDirectory(type, this.getContext());
                break;
            }
            case 200: {
                directory = FileUtils.getExternalFilesDir(type, this.getContext());
                break;
            }
            case 300: {
                directory = FileUtils.getExternalCacheDir(this.getContext());
                break;
            }
            case 400: {
                directory = FileUtils.getInternalFileDirectory(this.getContext());
            }
        }
        return directory;
    }

    @TargetApi(value=11)
    protected Context getContext() {
        if (this.activity != null) {
            return this.activity;
        }
        if (this.fragment != null) {
            return this.fragment.getActivity();
        }
        if (this.appFragment != null) {
            return this.appFragment.getActivity();
        }
        return null;
    }

    @TargetApi(value=11)
    protected void pickInternal(Intent intent, int type) {
        if (this.allowMultiple && Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        if (this.activity != null) {
            this.activity.startActivityForResult(intent, type);
        } else if (this.fragment != null) {
            this.fragment.startActivityForResult(intent, type);
        } else if (this.appFragment != null) {
            this.appFragment.startActivityForResult(intent, type);
        }
    }

    protected boolean isClipDataApi() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    private void checkIfPermissionsAvailable() {
        boolean writePermissionInManifest = this.getContext().checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        LogUtils.d(TAG, "checkIfPermissionsAvailable: In Manifest(WRITE_EXTERNAL_STORAGE): " + writePermissionInManifest);
        boolean readPermissionInManifest = this.getContext().checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0;
        LogUtils.d(TAG, "checkIfPermissionsAvailable: In Manifest(READ_EXTERNAL_STORAGE): " + readPermissionInManifest);
        if (!writePermissionInManifest || !readPermissionInManifest) {
            if (!writePermissionInManifest) {
                LogUtils.e(TAG, "android.permission.WRITE_EXTERNAL_STORAGE permission is missing in manifest file");
            }
            if (!readPermissionInManifest) {
                LogUtils.e(TAG, "android.permission.READ_EXTERNAL_STORAGE permission is missing in manifest file");
            }
            throw new RuntimeException("Permissions required in Manifest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long querySizeOfFile(Uri uri, Context context) {
        if (uri.toString().startsWith("file")) {
            File file = new File(uri.getPath());
            return file.length();
        }
        if (uri.toString().startsWith("content")) {
            try (Cursor cursor = null;){
                cursor = context.getContentResolver().query(uri, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    long l = cursor.getLong(cursor.getColumnIndex("_size"));
                    return l;
                }
                long l = 0L;
                return l;
            }
        }
        return 0L;
    }

    protected String getNewFileLocation(String extension, String type) throws PickerException {
        String filePathName = "";
        if (type.equals(Environment.DIRECTORY_MOVIES)) {
            filePathName = "movies";
        } else if (type.equals(Environment.DIRECTORY_PICTURES)) {
            filePathName = "pictures";
        }
        File file = new File(this.getContext().getFilesDir(), filePathName);
        file.mkdirs();
        file = new File(file.getAbsolutePath() + File.separator + UUID.randomUUID().toString() + "." + extension);
        return file.getAbsolutePath();
    }

    protected String getFileProviderAuthority() {
        return this.getContext().getPackageName() + ".multipicker.fileprovider";
    }

    public void setDebugglable(boolean debugglable) {
        new StoragePreferences(this.getContext()).setDebuggable(debugglable);
    }
}

