/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.kbeanie.multipicker.api.callbacks.VideoPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenVideo;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.PickerManager;
import com.kbeanie.multipicker.core.threads.VideoProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class VideoPickerImpl
extends PickerManager {
    private static final String TAG = VideoPickerImpl.class.getSimpleName();
    private String path;
    protected VideoPickerCallback callback;
    private boolean generatePreviewImages = true;
    private boolean generateMetadata = true;
    private int quality = 100;

    public VideoPickerImpl(Activity activity, int pickerType) {
        super(activity, pickerType);
    }

    public VideoPickerImpl(androidx.fragment.app.Fragment fragment, int pickerType) {
        super(fragment, pickerType);
    }

    public VideoPickerImpl(Fragment appFragment, int pickerType) {
        super(appFragment, pickerType);
    }

    public void reinitialize(String path) {
        this.path = path;
    }

    public void setVideoPickerCallback(VideoPickerCallback callback) {
        this.callback = callback;
    }

    public void shouldGeneratePreviewImages(boolean generatePreviewImages) {
        this.generatePreviewImages = generatePreviewImages;
    }

    public void shouldGenerateMetadata(boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    protected String pick() throws PickerException {
        if (this.callback == null) {
            throw new PickerException("VideoPickerCallback null!!! Please set one");
        }
        if (this.pickerType == 5333) {
            return this.pickLocalVideo();
        }
        if (this.pickerType == 6444) {
            this.path = this.takeVideoWithCamera();
            return this.path;
        }
        return null;
    }

    protected String takeVideoWithCamera() throws PickerException {
        String tempFilePath;
        Uri uri = null;
        if (Build.VERSION.SDK_INT >= 24) {
            tempFilePath = this.getNewFileLocation("mp4", Environment.DIRECTORY_MOVIES);
            File file = new File(tempFilePath);
            uri = FileProvider.getUriForFile((Context)this.getContext(), (String)this.getFileProviderAuthority(), (File)file);
            LogUtils.d(TAG, "takeVideoWithCamera: Temp Uri: " + uri.getPath());
        } else {
            tempFilePath = this.buildFilePath("mp4", Environment.DIRECTORY_MOVIES);
            uri = Uri.fromFile((File)new File(tempFilePath));
        }
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        LogUtils.d(TAG, "Temp Path for Camera capture: " + tempFilePath);
        this.pickInternal(intent, 6444);
        return tempFilePath;
    }

    protected String pickLocalVideo() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("video/*");
        if (this.extras != null) {
            intent.putExtras(this.extras);
        }
        intent.addFlags(1);
        this.pickInternal(intent, 5333);
        return null;
    }

    @Override
    public void submit(Intent data) {
        if (this.pickerType == 6444) {
            this.handleCameraData(data);
        } else if (this.pickerType == 5333) {
            this.handleGalleryData(data);
        }
    }

    private void handleCameraData(Intent data) {
        LogUtils.d(TAG, "handleCameraData: " + this.path);
        if (this.path == null || this.path.isEmpty()) {
            throw new RuntimeException("Camera Path cannot be null. Re-initialize with correct path value.");
        }
        ArrayList<String> uris = new ArrayList<String>();
        File file = new File(this.path);
        if (!file.exists()) {
            uris.add(data.getDataString());
        } else {
            uris.add(Uri.fromFile((File)file).toString());
        }
        this.processVideos(uris);
    }

    @SuppressLint(value={"NewApi"})
    private void handleGalleryData(Intent intent) {
        ArrayList<String> uris = new ArrayList<String>();
        if (intent != null) {
            int i;
            if (intent.getDataString() != null && this.isClipDataApi() && intent.getClipData() == null) {
                String uri = intent.getDataString();
                LogUtils.d(TAG, "handleGalleryData: " + uri);
                uris.add(uri);
            } else if (this.isClipDataApi() && intent.getClipData() != null) {
                ClipData clipData = intent.getClipData();
                LogUtils.d(TAG, "handleGalleryData: Multiple videos with ClipData");
                for (i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    LogUtils.d(TAG, "Item [" + i + "]: " + item.getUri().toString());
                    uris.add(item.getUri().toString());
                }
            }
            if (intent.hasExtra("uris")) {
                ArrayList paths = intent.getParcelableArrayListExtra("uris");
                for (i = 0; i < paths.size(); ++i) {
                    uris.add(((Uri)paths.get(i)).toString());
                }
            }
            this.processVideos(uris);
        }
    }

    private void processVideos(List<String> uris) {
        VideoProcessorThread thread = new VideoProcessorThread(this.getContext(), this.getVideoObjects(uris), this.cacheLocation);
        thread.setRequestId(this.requestId);
        thread.setShouldGeneratePreviewImages(this.generatePreviewImages);
        thread.setShouldGenerateMetadata(this.generateMetadata);
        thread.setThumbnailsImageQuality(this.quality);
        thread.setVideoPickerCallback(this.callback);
        thread.start();
    }

    private List<ChosenVideo> getVideoObjects(List<String> uris) {
        ArrayList<ChosenVideo> videos = new ArrayList<ChosenVideo>();
        for (String uri : uris) {
            ChosenVideo video = new ChosenVideo();
            video.setQueryUri(uri);
            video.setDirectoryType(Environment.DIRECTORY_MOVIES);
            video.setType("video");
            videos.add(video);
        }
        return videos;
    }

    private void onError(final String errorMessage) {
        try {
            if (this.callback != null) {
                ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        VideoPickerImpl.this.callback.onError(errorMessage);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

