/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core.threads;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import com.kbeanie.multipicker.api.callbacks.AudioPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenAudio;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.core.threads.FileProcessorThread;
import java.util.List;

public final class AudioProcessorThread
extends FileProcessorThread {
    private AudioPickerCallback callback;

    public AudioProcessorThread(Context context, List<? extends ChosenFile> files, int cacheLocation) {
        super(context, files, cacheLocation);
    }

    @Override
    public void run() {
        super.run();
        this.postProcessAudios();
        this.onDone();
    }

    private void postProcessAudios() {
        for (ChosenFile file : this.files) {
            ChosenAudio audio = (ChosenAudio)file;
            this.postProcessAudio(audio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcessAudio(ChosenAudio audio) {
        MediaMetadataRetriever metadataRetriever = new MediaMetadataRetriever();
        try {
            metadataRetriever.setDataSource(audio.getOriginalPath());
            String duration = metadataRetriever.extractMetadata(9);
            if (duration != null) {
                audio.setDuration(Long.parseLong(duration));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            metadataRetriever.release();
        }
    }

    private void onDone() {
        try {
            if (this.callback != null) {
                this.getActivityFromContext().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AudioProcessorThread.this.callback.onAudiosChosen(AudioProcessorThread.this.files);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void setAudioPickerCallback(AudioPickerCallback callback) {
        this.callback = callback;
    }
}

