/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core.threads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.kbeanie.multipicker.api.callbacks.FilePickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.utils.BitmapUtils;
import com.kbeanie.multipicker.utils.FileUtils;
import com.kbeanie.multipicker.utils.LogUtils;
import com.kbeanie.multipicker.utils.MimeUtils;
import com.kbeanie.multipicker.utils.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public class FileProcessorThread
extends Thread {
    protected static final int THUMBNAIL_BIG = 1;
    protected static final int THUMBNAIL_SMALL = 2;
    private static final String TAG = FileProcessorThread.class.getSimpleName();
    private final int cacheLocation;
    protected final Context context;
    protected final List<? extends ChosenFile> files;
    private FilePickerCallback callback;
    private int requestId;

    public FileProcessorThread(Context context, List<? extends ChosenFile> files, int cacheLocation) {
        this.context = context;
        this.files = files;
        this.cacheLocation = cacheLocation;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    @Override
    public void run() {
        this.processFiles();
        if (this.callback != null) {
            this.onDone();
        }
    }

    private void onDone() {
        try {
            if (this.callback != null) {
                ((Activity)this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FileProcessorThread.this.callback.onFilesChosen(FileProcessorThread.this.files);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    protected void processFiles() {
        for (ChosenFile chosenFile : this.files) {
            try {
                chosenFile.setRequestId(this.requestId);
                LogUtils.d(TAG, "processFile: Before: " + chosenFile.toString());
                this.processFile(chosenFile);
                this.postProcess(chosenFile);
                chosenFile.setSuccess(true);
                LogUtils.d(TAG, "processFile: Final Path: " + chosenFile.toString());
            }
            catch (PickerException e) {
                e.printStackTrace();
                chosenFile.setSuccess(false);
            }
        }
    }

    protected void postProcessFiles() {
        for (ChosenFile chosenFile : this.files) {
            try {
                this.postProcess(chosenFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void postProcess(ChosenFile file) throws PickerException {
        file.setCreatedAt(Calendar.getInstance().getTime());
        File f = new File(file.getOriginalPath());
        file.setSize(f.length());
        this.copyFileToFolder(file);
    }

    private void copyFileToFolder(ChosenFile file) throws PickerException {
        LogUtils.d(TAG, "copyFileToFolder: folder: " + file.getDirectoryType());
        LogUtils.d(TAG, "copyFileToFolder: extension: " + file.getExtension());
        LogUtils.d(TAG, "copyFileToFolder: mimeType: " + file.getMimeType());
        LogUtils.d(TAG, "copyFileToFolder: type: " + file.getType());
        if (file.getType().equals("image")) {
            file.setDirectoryType(Environment.DIRECTORY_PICTURES);
        } else if (file.getType().equals("video")) {
            file.setDirectoryType(Environment.DIRECTORY_MOVIES);
        }
        String outputPath = this.getTargetLocationToCopy(file);
        LogUtils.d(TAG, "copyFileToFolder: Out Path: " + outputPath);
        if (outputPath.equals(file.getOriginalPath())) {
            return;
        }
        try {
            File inputFile = new File(file.getOriginalPath());
            File copyTo = new File(outputPath);
            FileUtils.copyFile(inputFile, copyTo);
            file.setOriginalPath(copyTo.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PickerException(e);
        }
    }

    private void processFile(ChosenFile file) throws PickerException {
        String uri = file.getQueryUri();
        LogUtils.d(TAG, "processFile: uri" + uri);
        if (uri.startsWith("file://") || uri.startsWith("/")) {
            file = this.sanitizeUri(file);
            file.setDisplayName(Uri.parse((String)file.getOriginalPath()).getLastPathSegment());
            file.setMimeType(this.guessMimeTypeFromUrl(file.getOriginalPath(), file.getType()));
        } else if (uri.startsWith("http")) {
            file = this.downloadAndSaveFile(file);
        } else if (uri.startsWith("content:")) {
            file = this.getAbsolutePathIfAvailable(file);
        }
        uri = file.getOriginalPath();
        if (uri.startsWith("content:")) {
            file = this.getFromContentProvider(file);
        }
        if ((uri = file.getOriginalPath()).startsWith("content:")) {
            file = this.getFromContentProviderAlternate(file);
        }
        try {
            String decodedURL = Uri.parse((String)Uri.decode((String)file.getOriginalPath())).toString();
            if (!decodedURL.equals(file.getOriginalPath())) {
                file.setOriginalPath(decodedURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ChosenFile sanitizeUri(ChosenFile file) {
        if (file.getQueryUri().startsWith("file://")) {
            file.setOriginalPath(file.getQueryUri().substring(7));
        }
        return file;
    }

    protected ChosenFile getFromContentProviderAlternate(ChosenFile file) throws PickerException {
        BufferedInputStream bStream;
        BufferedOutputStream outStream;
        block6: {
            outStream = null;
            bStream = null;
            try {
                int len;
                InputStream inputStream = this.context.getContentResolver().openInputStream(Uri.parse((String)file.getOriginalPath()));
                bStream = new BufferedInputStream(inputStream);
                String mimeType = URLConnection.guessContentTypeFromStream(inputStream);
                StreamHelper.verifyStream(file.getOriginalPath(), bStream);
                String localFilePath = this.generateFileName(file);
                outStream = new BufferedOutputStream(new FileOutputStream(localFilePath));
                byte[] buf = new byte[2048];
                while ((len = bStream.read(buf)) > 0) {
                    outStream.write(buf, 0, len);
                }
                file.setOriginalPath(localFilePath);
                if (file.getMimeType() == null || !file.getMimeType().contains("/*")) break block6;
                if (mimeType != null && !mimeType.isEmpty()) {
                    file.setMimeType(mimeType);
                    break block6;
                }
                file.setMimeType(this.guessMimeTypeFromUrl(file.getOriginalPath(), file.getType()));
            }
            catch (IOException e) {
                try {
                    throw new PickerException(e);
                }
                catch (Throwable throwable) {
                    StreamHelper.flush(outStream);
                    StreamHelper.close(bStream);
                    StreamHelper.close(outStream);
                    throw throwable;
                }
            }
        }
        StreamHelper.flush(outStream);
        StreamHelper.close(bStream);
        StreamHelper.close(outStream);
        return file;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChosenFile getFromContentProvider(ChosenFile file) throws PickerException {
        BufferedOutputStream outStream;
        BufferedInputStream inputStream;
        block10: {
            inputStream = null;
            outStream = null;
            ParcelFileDescriptor parcelFileDescriptor = null;
            try {
                int len;
                String localFilePath = this.generateFileName(file);
                parcelFileDescriptor = this.context.getContentResolver().openFileDescriptor(Uri.parse((String)file.getOriginalPath()), "r");
                StreamHelper.verifyStream(file.getOriginalPath(), parcelFileDescriptor);
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                inputStream = new BufferedInputStream(new FileInputStream(fileDescriptor));
                String mimeType = URLConnection.guessContentTypeFromStream(inputStream);
                BufferedInputStream reader = new BufferedInputStream(inputStream);
                outStream = new BufferedOutputStream(new FileOutputStream(localFilePath));
                byte[] buf = new byte[2048];
                while ((len = reader.read(buf)) > 0) {
                    outStream.write(buf, 0, len);
                }
                StreamHelper.flush(outStream);
                file.setOriginalPath(localFilePath);
                if (file.getMimeType() != null && file.getMimeType().contains("/*")) {
                    if (mimeType != null && !mimeType.isEmpty()) {
                        file.setMimeType(mimeType);
                    } else {
                        file.setMimeType(this.guessMimeTypeFromUrl(file.getOriginalPath(), file.getType()));
                    }
                }
                if (Build.VERSION.SDK_INT < 16) break block10;
            }
            catch (IOException e) {
                try {
                    throw new PickerException(e);
                    catch (Exception e2) {
                        throw new PickerException(e2.getLocalizedMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        StreamHelper.close(parcelFileDescriptor);
                    }
                    StreamHelper.flush(outStream);
                    StreamHelper.close(outStream);
                    StreamHelper.close(inputStream);
                    throw throwable;
                }
            }
            StreamHelper.close((Closeable)parcelFileDescriptor);
        }
        StreamHelper.flush(outStream);
        StreamHelper.close(outStream);
        StreamHelper.close(inputStream);
        return file;
    }

    private ChosenFile getAbsolutePathIfAvailable(ChosenFile file) {
        String[] projection = new String[]{"_data", "_display_name", "mime_type"};
        if (file.getQueryUri().startsWith("content://com.android.gallery3d.provider")) {
            file.setOriginalPath(Uri.parse((String)file.getQueryUri().replace("com.android.gallery3d", "com.google.android.gallery3d")).toString());
        } else {
            file.setOriginalPath(file.getQueryUri());
        }
        if (file.getOriginalPath().startsWith("content://")) {
            try {
                Cursor cursor = this.context.getContentResolver().query(Uri.parse((String)file.getOriginalPath()), projection, null, null, null);
                cursor.moveToFirst();
                try {
                    if (!file.getOriginalPath().contains("com.sec.android.gallery3d.provider")) {
                        String path = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                        LogUtils.d(TAG, "processFile: Path: " + path);
                        if (path != null) {
                            file.setOriginalPath(path);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    String displayName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                    if (displayName != null) {
                        file.setDisplayName(displayName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                if (mimeType != null) {
                    file.setMimeType(mimeType);
                }
                cursor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (file.getOriginalPath().startsWith("content:") && this.isDownloadsDocument(Uri.parse((String)file.getOriginalPath())) && Build.VERSION.SDK_INT >= 19) {
            String[] data = this.getPathAndMimeType(file);
            if (data[0] != null) {
                file.setOriginalPath(data[0]);
            }
            if (data[1] != null) {
                file.setMimeType(data[1]);
            }
        }
        return file;
    }

    @TargetApi(value=19)
    private String[] getPathAndMimeType(ChosenFile file) {
        boolean isKitKat = Build.VERSION.SDK_INT >= 19;
        Uri uri = Uri.parse((String)file.getOriginalPath());
        if (isKitKat && DocumentsContract.isDocumentUri((Context)this.context, (Uri)uri)) {
            if (this.isDownloadsDocument(uri)) {
                String id = DocumentsContract.getDocumentId((Uri)uri);
                if (id.startsWith("raw:")) {
                    String[] data = new String[]{id.replaceFirst("raw:", ""), null};
                    return data;
                }
                Uri contentUri = uri;
                if (Build.VERSION.SDK_INT < 26) {
                    contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                }
                return this.getDataAndMimeType(contentUri, null, null, file.getType());
            }
            if (this.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return this.getDataAndMimeType(contentUri, "_id=?", selectionArgs, file.getType());
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return this.getDataAndMimeType(uri, null, null, file.getType());
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                String path = uri.getPath();
                String mimeType = this.guessMimeTypeFromUrl(path, file.getType());
                String[] data = new String[]{path, mimeType};
                return data;
            }
        }
        return new String[]{null, null};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDataAndMimeType(Uri uri, String selection, String[] selectionArgs, String type) {
        String[] data = new String[2];
        String[] projection = new String[]{"_data"};
        try (Cursor cursor = null;){
            cursor = this.context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                String path;
                data[0] = path = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                data[1] = this.guessMimeTypeFromUrl(path, type);
                String[] stringArray = data;
                return stringArray;
            }
        }
        return data;
    }

    private boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private ChosenFile downloadAndSaveFile(ChosenFile file) {
        try {
            int len;
            URL u = new URL(file.getQueryUri());
            HttpURLConnection urlConnection = (HttpURLConnection)u.openConnection();
            BufferedInputStream stream = new BufferedInputStream(urlConnection.getInputStream());
            BufferedInputStream bStream = new BufferedInputStream(stream);
            String mimeType = this.guessMimeTypeFromUrl(file.getQueryUri(), file.getType());
            if (mimeType == null) {
                mimeType = URLConnection.guessContentTypeFromStream(stream);
            }
            if (mimeType == null && file.getQueryUri().contains(".")) {
                int index = file.getQueryUri().lastIndexOf(".");
                mimeType = file.getType() + "/" + file.getQueryUri().substring(index + 1);
            }
            if (mimeType == null) {
                mimeType = file.getType() + "/*";
            }
            file.setMimeType(mimeType);
            String localFilePath = this.generateFileName(file);
            File localFile = new File(localFilePath);
            FileOutputStream fileOutputStream = new FileOutputStream(localFile);
            byte[] buffer = new byte[2048];
            while ((len = bStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            bStream.close();
            file.setOriginalPath(localFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    protected String getTargetDirectory(String type) throws PickerException {
        String directory = null;
        switch (this.cacheLocation) {
            case 100: {
                directory = FileUtils.getExternalFilesDirectory(type, this.context);
                break;
            }
            case 200: {
                directory = FileUtils.getExternalFilesDir(type, this.context);
                break;
            }
            case 300: {
                directory = FileUtils.getExternalCacheDir(this.context);
                break;
            }
            case 400: {
                directory = FileUtils.getInternalFileDirectory(this.context);
                break;
            }
            default: {
                directory = FileUtils.getExternalFilesDirectory(type, this.context);
            }
        }
        return directory;
    }

    private String guessExtensionFromUrl(String url) {
        try {
            return MimeTypeMap.getFileExtensionFromUrl((String)url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String guessMimeTypeFromUrl(String url, String type) {
        String extension = this.guessExtensionFromUrl(url);
        if (extension == null || extension.isEmpty()) {
            if (url.contains(".")) {
                int index = url.lastIndexOf(".");
                extension = url.substring(index + 1);
            } else {
                extension = "*";
            }
        }
        String mimeType = type.equals("file") ? MimeUtils.guessMimeTypeFromExtension(extension) : type + "/" + extension;
        return mimeType;
    }

    private String getTargetLocationToCopy(ChosenFile file) throws PickerException {
        String extension;
        String fileName = file.getDisplayName();
        if (fileName == null || fileName.isEmpty()) {
            fileName = UUID.randomUUID().toString();
        }
        if (!fileName.contains(".") && (extension = file.getFileExtensionFromMimeType()) != null && !extension.isEmpty()) {
            fileName = fileName + extension;
            file.setExtension(extension);
        }
        String probableFileName = fileName;
        File probableFile = new File(this.getTargetDirectory(file.getDirectoryType()) + File.separator + probableFileName);
        return probableFile.getAbsolutePath();
    }

    private String generateFileName(ChosenFile file) throws PickerException {
        String extension;
        String fileName = file.getDisplayName();
        if (fileName == null || fileName.isEmpty()) {
            fileName = UUID.randomUUID().toString();
        }
        if (!fileName.contains(".") && (extension = file.getFileExtensionFromMimeType()) != null && !extension.isEmpty()) {
            fileName = fileName + extension;
            file.setExtension(extension);
        }
        if (TextUtils.isEmpty((CharSequence)file.getMimeType())) {
            file.setMimeType(this.guessMimeTypeFromUrl(file.getOriginalPath(), file.getType()));
        }
        String probableFileName = fileName;
        File probableFile = new File(this.getTargetDirectory(file.getDirectoryType()) + File.separator + probableFileName);
        int counter = 0;
        while (probableFile.exists()) {
            ++counter;
            if (fileName.contains(".")) {
                int indexOfDot = fileName.lastIndexOf(".");
                probableFileName = fileName.substring(0, indexOfDot - 1) + "-" + counter + "." + fileName.substring(indexOfDot + 1);
            } else {
                probableFileName = fileName + "(" + counter + ")";
            }
            probableFile = new File(this.getTargetDirectory(file.getDirectoryType()) + File.separator + probableFileName);
        }
        fileName = probableFileName;
        file.setDisplayName(fileName);
        return this.getTargetDirectory(file.getDirectoryType()) + File.separator + fileName;
    }

    protected String generateFileNameForVideoPreviewImage() throws PickerException {
        String fileName = UUID.randomUUID().toString();
        String extension = ".jpg";
        if (extension != null && !extension.isEmpty()) {
            fileName = fileName + extension;
        }
        return this.getTargetDirectory(Environment.DIRECTORY_PICTURES) + File.separator + fileName;
    }

    protected Activity getActivityFromContext() {
        return (Activity)this.context;
    }

    public void setFilePickerCallback(FilePickerCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChosenImage ensureMaxWidthAndHeight(int maxWidth, int maxHeight, int quality, ChosenImage image) {
        FileOutputStream stream = null;
        try {
            int imageHeight;
            int imageWidth;
            int[] scaledDimension;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BufferedInputStream boundsOnlyStream = new BufferedInputStream(new FileInputStream(image.getOriginalPath()));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)boundsOnlyStream, null, (BitmapFactory.Options)options);
            if (bitmap != null) {
                bitmap.recycle();
            }
            if (boundsOnlyStream != null) {
                boundsOnlyStream.close();
            }
            if ((scaledDimension = BitmapUtils.getScaledDimensions(imageWidth = options.outWidth, imageHeight = options.outHeight, maxWidth, maxHeight))[0] != imageWidth || scaledDimension[1] != imageHeight) {
                ExifInterface originalExifInterface = new ExifInterface(image.getOriginalPath());
                String originalRotation = originalExifInterface.getAttribute("Orientation");
                BufferedInputStream scaledInputStream = new BufferedInputStream(new FileInputStream(image.getOriginalPath()));
                options.inJustDecodeBounds = false;
                bitmap = BitmapFactory.decodeStream((InputStream)scaledInputStream, null, (BitmapFactory.Options)options);
                scaledInputStream.close();
                if (bitmap != null) {
                    File original = new File(image.getOriginalPath());
                    image.setTempFile(original.getAbsolutePath());
                    File file = new File(original.getParent() + File.separator + original.getName().replace(".", "-resized."));
                    stream = new FileOutputStream(file);
                    Matrix matrix = new Matrix();
                    matrix.postScale((float)scaledDimension[0] / (float)imageWidth, (float)scaledDimension[1] / (float)imageHeight);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)stream);
                    image.setOriginalPath(file.getAbsolutePath());
                    ExifInterface resizedExifInterface = new ExifInterface(file.getAbsolutePath());
                    resizedExifInterface.setAttribute("Orientation", originalRotation);
                    resizedExifInterface.saveAttributes();
                    image.setWidth(scaledDimension[0]);
                    image.setHeight(scaledDimension[1]);
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                StreamHelper.close(stream);
            }
            catch (PickerException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    protected String downScaleAndSaveImage(String image, int scale, int quality) throws PickerException {
        Closeable bstream;
        FileOutputStream stream;
        block12: {
            String string;
            stream = null;
            bstream = null;
            try {
                BitmapFactory.Options optionsForGettingDimensions = new BitmapFactory.Options();
                optionsForGettingDimensions.inJustDecodeBounds = true;
                BufferedInputStream boundsOnlyStream = new BufferedInputStream(new FileInputStream(image));
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)boundsOnlyStream, null, (BitmapFactory.Options)optionsForGettingDimensions);
                if (bitmap != null) {
                    bitmap.recycle();
                }
                if (boundsOnlyStream != null) {
                    boundsOnlyStream.close();
                }
                int w = optionsForGettingDimensions.outWidth;
                int l = optionsForGettingDimensions.outHeight;
                ExifInterface exif = new ExifInterface(image);
                int orientation = exif.getAttributeInt("Orientation", 1);
                int rotate = 0;
                switch (orientation) {
                    case 8: {
                        rotate = -90;
                        break;
                    }
                    case 3: {
                        rotate = 180;
                        break;
                    }
                    case 6: {
                        rotate = 90;
                    }
                }
                int what = w > l ? w : l;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = what > 3000 ? scale * 6 : (what > 2000 && what <= 3000 ? scale * 5 : (what > 1500 && what <= 2000 ? scale * 4 : (what > 1000 && what <= 1500 ? scale * 3 : (what > 400 && what <= 1000 ? scale * 2 : scale))));
                options.inJustDecodeBounds = false;
                BufferedInputStream scaledInputStream = new BufferedInputStream(new FileInputStream(image));
                bitmap = BitmapFactory.decodeStream((InputStream)scaledInputStream, null, (BitmapFactory.Options)options);
                scaledInputStream.close();
                if (bitmap == null) break block12;
                File original = new File(URLDecoder.decode(image, Charset.defaultCharset().name()));
                File file = new File(original.getParent() + File.separator + original.getName().replace(".", "-scale-" + scale + "."));
                stream = new FileOutputStream(file);
                if (rotate != 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)rotate);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
                }
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)stream);
                string = file.getAbsolutePath();
            }
            catch (Exception e) {
                try {
                    throw new PickerException("Error while generating thumbnail: " + scale + " " + image);
                }
                catch (Throwable throwable) {
                    StreamHelper.close(bstream);
                    StreamHelper.flush(stream);
                    StreamHelper.close(stream);
                    throw throwable;
                }
            }
            StreamHelper.close(bstream);
            StreamHelper.flush(stream);
            StreamHelper.close(stream);
            return string;
        }
        StreamHelper.close(bstream);
        StreamHelper.flush(stream);
        StreamHelper.close(stream);
        return null;
    }

    protected String getWidthOfImage(String path) {
        String width = "";
        try {
            ExifInterface exif = new ExifInterface(path);
            width = exif.getAttribute("ImageWidth");
            if ("0".equals(width)) {
                SoftReference<Bitmap> bmp = this.getBitmapImage(path);
                width = Integer.toString(bmp.get().getWidth());
                bmp.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return width;
    }

    protected String getHeightOfImage(String path) {
        String height = "";
        try {
            ExifInterface exif = new ExifInterface(path);
            height = exif.getAttribute("ImageLength");
            if ("0".equals(height)) {
                SoftReference<Bitmap> bmp = this.getBitmapImage(path);
                height = Integer.toString(bmp.get().getHeight());
                bmp.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return height;
    }

    protected SoftReference<Bitmap> getBitmapImage(String path) {
        SoftReference<Bitmap> bitmap = new SoftReference<Bitmap>(BitmapFactory.decodeFile((String)Uri.fromFile((File)new File(path)).getPath()));
        return bitmap;
    }

    protected int getOrientation(String image) {
        int orientation = 1;
        try {
            ExifInterface exif = new ExifInterface(image);
            orientation = exif.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orientation;
    }
}

