/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core.threads;

import android.content.Context;
import com.kbeanie.multipicker.api.callbacks.ImagePickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.threads.FileProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import java.util.List;

public final class ImageProcessorThread
extends FileProcessorThread {
    private static final String TAG = ImageProcessorThread.class.getSimpleName();
    private boolean shouldGenerateThumbnails;
    private boolean shouldGenerateMetadata;
    private int maxImageWidth = -1;
    private int maxImageHeight = -1;
    private int quality = 100;
    private ImagePickerCallback callback;

    public ImageProcessorThread(Context context, List<ChosenImage> paths, int cacheLocation) {
        super(context, paths, cacheLocation);
    }

    public void setShouldGenerateThumbnails(boolean shouldGenerateThumbnails) {
        this.shouldGenerateThumbnails = shouldGenerateThumbnails;
    }

    public void setImagePickerCallback(ImagePickerCallback callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        super.run();
        this.postProcessImages();
        this.onDone();
    }

    private void onDone() {
        try {
            if (this.callback != null) {
                this.getActivityFromContext().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ImageProcessorThread.this.callback.onImagesChosen(ImageProcessorThread.this.files);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void postProcessImages() {
        for (ChosenFile file : this.files) {
            ChosenImage image = (ChosenImage)file;
            try {
                this.postProcessImage(image);
                image.setSuccess(true);
            }
            catch (PickerException e) {
                e.printStackTrace();
                image.setSuccess(false);
            }
        }
    }

    private ChosenImage postProcessImage(ChosenImage image) throws PickerException {
        if (this.maxImageWidth != -1 && this.maxImageHeight != -1) {
            image = this.ensureMaxWidthAndHeight(this.maxImageWidth, this.maxImageHeight, this.quality, image);
        }
        LogUtils.d(TAG, "postProcessImage: " + image.getMimeType());
        if (this.shouldGenerateMetadata) {
            try {
                image = this.generateMetadata(image);
            }
            catch (Exception e) {
                LogUtils.d(TAG, "postProcessImage: Error generating metadata");
                e.printStackTrace();
            }
        }
        if (this.shouldGenerateThumbnails) {
            image = this.generateThumbnails(image);
        }
        LogUtils.d(TAG, "postProcessImage: " + image);
        return image;
    }

    private ChosenImage generateMetadata(ChosenImage image) {
        image.setWidth(Integer.parseInt(this.getWidthOfImage(image.getOriginalPath())));
        image.setHeight(Integer.parseInt(this.getHeightOfImage(image.getOriginalPath())));
        image.setOrientation(this.getOrientation(image.getOriginalPath()));
        return image;
    }

    private ChosenImage generateThumbnails(ChosenImage image) throws PickerException {
        String thumbnailBig = this.downScaleAndSaveImage(image.getOriginalPath(), 1, this.quality);
        image.setThumbnailPath(thumbnailBig);
        String thumbnailSmall = this.downScaleAndSaveImage(image.getOriginalPath(), 2, this.quality);
        image.setThumbnailSmallPath(thumbnailSmall);
        return image;
    }

    public void setShouldGenerateMetadata(boolean shouldGenerateMetadata) {
        this.shouldGenerateMetadata = shouldGenerateMetadata;
    }

    public void setOutputImageDimensions(int maxWidth, int maxHeight) {
        this.maxImageWidth = maxWidth;
        this.maxImageHeight = maxHeight;
    }

    public void setOutputImageQuality(int quality) {
        this.quality = quality;
    }
}

