/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.core.threads;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.os.Build;
import com.kbeanie.multipicker.api.callbacks.VideoPickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenFile;
import com.kbeanie.multipicker.api.entity.ChosenVideo;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import com.kbeanie.multipicker.core.threads.FileProcessorThread;
import com.kbeanie.multipicker.utils.LogUtils;
import com.kbeanie.multipicker.utils.StreamHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class VideoProcessorThread
extends FileProcessorThread {
    private static final String TAG = VideoProcessorThread.class.getSimpleName();
    private VideoPickerCallback callback;
    private boolean shouldGenerateMetadata;
    private boolean shouldGeneratePreviewImages;
    private int quality = 100;

    public VideoProcessorThread(Context context, List<? extends ChosenFile> files, int cacheLocation) {
        super(context, files, cacheLocation);
    }

    public void setVideoPickerCallback(VideoPickerCallback callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        super.run();
        this.postProcessVideos();
        this.onDone();
    }

    private void postProcessVideos() {
        for (ChosenFile file : this.files) {
            ChosenVideo video = (ChosenVideo)file;
            try {
                this.postProcessVideo(video);
                video.setSuccess(true);
            }
            catch (PickerException e) {
                e.printStackTrace();
                video.setSuccess(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcessVideo(ChosenVideo video) throws PickerException {
        if (this.shouldGenerateMetadata) {
            MediaMetadataRetriever metadataRetriever = new MediaMetadataRetriever();
            try {
                metadataRetriever.setDataSource(video.getOriginalPath());
                String duration = metadataRetriever.extractMetadata(9);
                String orientation = null;
                if (Build.VERSION.SDK_INT >= 17) {
                    orientation = metadataRetriever.extractMetadata(24);
                }
                String height = null;
                if (Build.VERSION.SDK_INT >= 14) {
                    height = metadataRetriever.extractMetadata(19);
                }
                String width = null;
                if (Build.VERSION.SDK_INT >= 14) {
                    width = metadataRetriever.extractMetadata(18);
                }
                if (duration != null) {
                    video.setDuration(Long.parseLong(duration));
                }
                if (orientation != null) {
                    video.setOrientation(Integer.parseInt(orientation));
                }
                if (height != null) {
                    video.setHeight(Integer.parseInt(height));
                }
                if (width != null) {
                    video.setWidth(Integer.parseInt(width));
                }
            }
            catch (Exception e) {
                LogUtils.d(TAG, "postProcessVideo: Error generating metadata");
                e.printStackTrace();
            }
            finally {
                metadataRetriever.release();
            }
        }
        if (this.shouldGeneratePreviewImages) {
            String previewPath = this.createPreviewImage(video.getOriginalPath());
            video.setPreviewImage(previewPath);
            String previewThumbnail = this.downScaleAndSaveImage(previewPath, 1, this.quality);
            String previewThumbnailSmall = this.downScaleAndSaveImage(previewPath, 2, this.quality);
            video.setPreviewThumbnail(previewThumbnail);
            video.setPreviewThumbnailSmall(previewThumbnailSmall);
        }
    }

    private void onDone() {
        try {
            if (this.callback != null) {
                this.getActivityFromContext().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        VideoProcessorThread.this.callback.onVideosChosen(VideoProcessorThread.this.files);
                    }
                });
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void setShouldGenerateMetadata(boolean shouldGenerateMetadata) {
        this.shouldGenerateMetadata = shouldGenerateMetadata;
    }

    public void setShouldGeneratePreviewImages(boolean shouldGeneratePreviewImages) {
        this.shouldGeneratePreviewImages = shouldGeneratePreviewImages;
    }

    private String createPreviewImage(String videoPath) throws PickerException {
        String previewImage = null;
        Bitmap bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)2);
        if (bitmap != null) {
            previewImage = this.generateFileNameForVideoPreviewImage();
            File file = new File(previewImage);
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
            }
            catch (IOException e) {
                try {
                    throw new PickerException(e);
                }
                catch (Throwable throwable) {
                    StreamHelper.flush(stream);
                    StreamHelper.close(stream);
                    throw throwable;
                }
            }
            StreamHelper.flush(stream);
            StreamHelper.close(stream);
        }
        return previewImage;
    }

    public void setThumbnailsImageQuality(int quality) {
        this.quality = quality;
    }
}

