/*
 * Decompiled with CFR 0.152.
 */
package com.kbeanie.multipicker.utils;

import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.kbeanie.multipicker.api.exceptions.PickerException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamHelper {
    static final String TAG = StreamHelper.class.getSimpleName();

    public static void closeSilent(Closeable stream) {
        try {
            StreamHelper.close(stream);
        }
        catch (PickerException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Closeable stream) throws PickerException {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new PickerException(e);
            }
        }
    }

    public static void flush(OutputStream stream) throws PickerException {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new PickerException(e);
            }
        }
    }

    public static void verifyCursor(Uri uri, Cursor cursor) throws PickerException {
        if (cursor == null) {
            throw new PickerException("Didnt not get cursor in return for = " + uri);
        }
    }

    public static void verifyStream(String path, ParcelFileDescriptor descriptor) throws PickerException {
        if (descriptor == null) {
            throw new PickerException("Could not read file descriptor from file at path = " + path);
        }
    }

    public static void verifyStream(String path, InputStream is) throws PickerException {
        if (is == null) {
            throw new PickerException("Could not open stream to read path = " + path);
        }
    }

    public static void verifyBitmap(String path, Bitmap bitmap) throws PickerException {
        if (bitmap == null) {
            throw new PickerException("Could not read bitmap from this path = " + path);
        }
    }

    public static boolean isNonNull(Bitmap bitmap) {
        if (bitmap != null) {
            return true;
        }
        Log.w((String)TAG, (String)"Bitmap is null. No good.");
        return false;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            byteArrayOutputStream.write(buffer, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

