/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchAppenderStatistics;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchAppenderStatisticsMXBean;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchWriterFactory;
import com.kdgregory.log4j.aws.internal.shared.AbstractAppender;
import com.kdgregory.log4j.aws.internal.shared.DefaultThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.Substitutions;
import java.util.Date;

public class CloudWatchAppender
extends AbstractAppender<CloudWatchWriterConfig, CloudWatchAppenderStatistics, CloudWatchAppenderStatisticsMXBean> {
    private String logGroup;
    private String logStream = "{startupTimestamp}";
    private String actualLogGroup;
    private String actualLogStream;

    public CloudWatchAppender() {
        super(new DefaultThreadFactory(), new CloudWatchWriterFactory(), new CloudWatchAppenderStatistics(), CloudWatchAppenderStatisticsMXBean.class);
    }

    public void setLogGroup(String value) {
        this.logGroup = value;
    }

    public String getLogGroup() {
        return this.logGroup;
    }

    public void setLogStream(String value) {
        this.logStream = value;
    }

    public String getLogStream() {
        return this.logStream;
    }

    @Override
    public void rotate() {
        super.rotate();
    }

    @Override
    protected CloudWatchWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), this.sequence.get());
        this.actualLogGroup = subs.perform(this.logGroup);
        this.actualLogStream = subs.perform(this.logStream);
        return new CloudWatchWriterConfig(this.actualLogGroup, this.actualLogStream, this.batchDelay, this.discardThreshold, this.discardAction, this.clientFactory, this.clientEndpoint);
    }

    @Override
    protected boolean isMessageTooLarge(LogMessage message) {
        return message.size() + 26 >= 0x100000;
    }
}

