/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.kinesis.KinesisAppenderStatistics;
import com.kdgregory.log4j.aws.internal.kinesis.KinesisAppenderStatisticsMXBean;
import com.kdgregory.log4j.aws.internal.kinesis.KinesisWriterConfig;
import com.kdgregory.log4j.aws.internal.kinesis.KinesisWriterFactory;
import com.kdgregory.log4j.aws.internal.shared.AbstractAppender;
import com.kdgregory.log4j.aws.internal.shared.DefaultThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.Substitutions;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class KinesisAppender
extends AbstractAppender<KinesisWriterConfig, KinesisAppenderStatistics, KinesisAppenderStatisticsMXBean> {
    private String streamName;
    private String partitionKey = "{startupTimestamp}";
    private boolean autoCreate;
    private int shardCount = 1;
    private Integer retentionPeriod;
    private String actualStreamName;
    private String actualPartitionKey;
    private int partitionKeyLength;

    public KinesisAppender() {
        super(new DefaultThreadFactory(), new KinesisWriterFactory(), new KinesisAppenderStatistics(), KinesisAppenderStatisticsMXBean.class);
    }

    public void setStreamName(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        this.streamName = value;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setPartitionKey(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        this.partitionKey = value;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void setRetentionPeriod(int value) {
        if (value <= 24 || value > 168) {
            throw new IllegalArgumentException("retentionPeriod must be between 25 and 168");
        }
        this.retentionPeriod = value;
    }

    public int getRetentionPeriod() {
        return this.retentionPeriod != null ? this.retentionPeriod : 24;
    }

    @Override
    protected KinesisWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), this.sequence.get());
        this.actualStreamName = subs.perform(this.streamName);
        this.actualPartitionKey = subs.perform(this.partitionKey);
        try {
            this.partitionKeyLength = this.actualPartitionKey.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("JVM doesn't support UTF-8 (should never happen)");
        }
        return new KinesisWriterConfig(this.actualStreamName, this.actualPartitionKey, this.partitionKeyLength, this.batchDelay, this.discardThreshold, this.discardAction, this.clientFactory, this.clientEndpoint, this.autoCreate, this.shardCount, this.retentionPeriod);
    }

    @Override
    protected boolean isMessageTooLarge(LogMessage message) {
        return message.size() + this.partitionKeyLength >= 0x100000;
    }
}

