/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.shared.AbstractAppender;
import com.kdgregory.log4j.aws.internal.shared.DefaultThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.Substitutions;
import com.kdgregory.log4j.aws.internal.sns.SNSAppenderStatistics;
import com.kdgregory.log4j.aws.internal.sns.SNSAppenderStatisticsMXBean;
import com.kdgregory.log4j.aws.internal.sns.SNSWriterConfig;
import com.kdgregory.log4j.aws.internal.sns.SNSWriterFactory;
import java.util.Date;

public class SNSAppender
extends AbstractAppender<SNSWriterConfig, SNSAppenderStatistics, SNSAppenderStatisticsMXBean> {
    private String topicName;
    private String topicArn;
    private String subject;
    private boolean autoCreate;

    public SNSAppender() {
        super(new DefaultThreadFactory(), new SNSWriterFactory(), new SNSAppenderStatistics(), SNSAppenderStatisticsMXBean.class);
        super.setDiscardThreshold(1000);
        super.setBatchDelay(1L);
    }

    public void setTopicName(String value) {
        this.topicName = value;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicArn(String value) {
        this.topicArn = value;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    @Override
    public void setBatchDelay(long value) {
        super.setBatchDelay(1L);
    }

    public void setSubject(String value) {
        this.subject = value;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setAutoCreate(boolean value) {
        this.autoCreate = value;
    }

    public boolean getAutoCreate() {
        return this.autoCreate;
    }

    @Override
    protected SNSWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), this.sequence.get());
        String actualTopicName = subs.perform(this.topicName);
        String actualTopicArn = subs.perform(this.topicArn);
        String actualSubject = subs.perform(this.subject);
        return new SNSWriterConfig(actualTopicName, actualTopicArn, this.autoCreate, actualSubject, this.discardThreshold, this.discardAction, this.clientFactory, this.clientEndpoint);
    }

    @Override
    protected boolean isMessageTooLarge(LogMessage message) {
        return message.size() > 262144;
    }
}

