/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.cloudwatch;

import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.OperationAbortedException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchAppenderStatistics;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.log4j.aws.internal.shared.AbstractLogWriter;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.LogLog;

public class CloudWatchLogWriter
extends AbstractLogWriter {
    private String groupName;
    private String streamName;
    private String clientFactoryMethod;
    private String clientEndpoint;
    protected AWSLogs client;
    private CloudWatchAppenderStatistics stats;

    public CloudWatchLogWriter(CloudWatchWriterConfig config, CloudWatchAppenderStatistics stats) {
        super(stats, config.batchDelay, config.discardThreshold, config.discardAction);
        this.groupName = config.logGroup;
        this.streamName = config.logStream;
        this.clientFactoryMethod = config.clientFactoryMethod;
        this.clientEndpoint = config.clientEndpoint;
        this.stats = stats;
        this.stats.setActualLogGroupName(this.groupName);
        this.stats.setActualLogStreamName(this.streamName);
    }

    @Override
    protected void createAWSClient() {
        this.client = this.tryClientFactory(this.clientFactoryMethod, AWSLogs.class, true);
        if (this.client == null && this.clientEndpoint == null) {
            this.client = this.tryClientFactory("com.amazonaws.services.logs.AWSLogsClientBuilder.defaultClient", AWSLogs.class, false);
        }
        if (this.client == null) {
            LogLog.debug((String)(this.getClass().getSimpleName() + ": creating service client via constructor"));
            this.client = (AWSLogs)this.tryConfigureEndpointOrRegion(new AWSLogsClient(), this.clientEndpoint);
        }
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        if (!Pattern.matches("[A-Za-z0-9_/.-]{1,512}", this.groupName)) {
            return this.initializationFailure("invalid log group name: " + this.groupName, null);
        }
        if (!Pattern.matches("[^:*]{1,512}", this.streamName)) {
            return this.initializationFailure("invalid log stream name: " + this.streamName, null);
        }
        try {
            LogStream logStream;
            LogGroup logGroup = this.findLogGroup();
            if (logGroup == null) {
                LogLog.debug((String)("creating CloudWatch log group: " + this.groupName));
                this.createLogGroup();
            }
            if ((logStream = this.findLogStream()) == null) {
                LogLog.debug((String)("creating CloudWatch log stream: " + this.streamName));
                this.createLogStream();
            }
            return true;
        }
        catch (Exception ex) {
            return this.initializationFailure("unable to configure log group/stream", ex);
        }
    }

    @Override
    protected List<LogMessage> processBatch(List<LogMessage> currentBatch) {
        Collections.sort(currentBatch);
        return this.attemptToSend(currentBatch);
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size() + 26;
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes < 0x100000 && numMessages < 10000;
    }

    private List<LogMessage> attemptToSend(List<LogMessage> batch) {
        if (batch.isEmpty()) {
            return batch;
        }
        PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.groupName).withLogStreamName(this.streamName).withLogEvents(this.constructLogEvents(batch));
        LogStream stream = this.findLogStream();
        if (stream == null) {
            this.stats.setLastError("log stream missing: " + this.streamName, null);
            this.ensureDestinationAvailable();
            return batch;
        }
        try {
            request.setSequenceToken(stream.getUploadSequenceToken());
            this.client.putLogEvents(request);
            this.stats.updateMessagesSent(batch.size());
            return Collections.emptyList();
        }
        catch (Exception ex) {
            LogLog.error((String)"failed to send batch", (Throwable)ex);
            this.stats.setLastError(null, ex);
            return batch;
        }
    }

    private List<InputLogEvent> constructLogEvents(List<LogMessage> batch) {
        ArrayList<InputLogEvent> result = new ArrayList<InputLogEvent>(batch.size());
        for (LogMessage msg : batch) {
            InputLogEvent event = new InputLogEvent().withTimestamp(Long.valueOf(msg.getTimestamp())).withMessage(msg.getMessage());
            result.add(event);
        }
        return result;
    }

    private LogGroup findLogGroup() {
        DescribeLogGroupsResult result;
        DescribeLogGroupsRequest request = new DescribeLogGroupsRequest().withLogGroupNamePrefix(this.groupName);
        do {
            result = this.client.describeLogGroups(request);
            for (LogGroup group : result.getLogGroups()) {
                if (!group.getLogGroupName().equals(this.groupName)) continue;
                return group;
            }
            request.setNextToken(result.getNextToken());
        } while (result.getNextToken() != null);
        return null;
    }

    private void createLogGroup() {
        while (true) {
            try {
                CreateLogGroupRequest request = new CreateLogGroupRequest().withLogGroupName(this.groupName);
                this.client.createLogGroup(request);
                for (int ii = 0; ii < 300; ++ii) {
                    if (this.findLogGroup() != null) {
                        return;
                    }
                    Utils.sleepQuietly(100L);
                }
                throw new RuntimeException("unable to create log group after 30 seconds; aborting");
            }
            catch (ResourceAlreadyExistsException ex) {
                return;
            }
            catch (OperationAbortedException ex) {
                Utils.sleepQuietly(250L);
                continue;
            }
            break;
        }
    }

    private LogStream findLogStream() {
        DescribeLogStreamsResult result;
        DescribeLogStreamsRequest request = new DescribeLogStreamsRequest().withLogGroupName(this.groupName).withLogStreamNamePrefix(this.streamName);
        do {
            result = this.client.describeLogStreams(request);
            for (LogStream stream : result.getLogStreams()) {
                if (!stream.getLogStreamName().equals(this.streamName)) continue;
                return stream;
            }
            request.setNextToken(result.getNextToken());
        } while (result.getNextToken() != null);
        return null;
    }

    private void createLogStream() {
        try {
            CreateLogStreamRequest request = new CreateLogStreamRequest().withLogGroupName(this.groupName).withLogStreamName(this.streamName);
            this.client.createLogStream(request);
            for (int ii = 0; ii < 300; ++ii) {
                if (this.findLogStream() != null) {
                    return;
                }
                Utils.sleepQuietly(100L);
            }
            throw new RuntimeException("unable to create log strean after 30 seconds; aborting");
        }
        catch (ResourceAlreadyExistsException ex) {
            return;
        }
    }
}

