/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.kdgregory.log4j.aws.internal.shared.AbstractAppenderStatistics;
import com.kdgregory.log4j.aws.internal.shared.JMXManager;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.LogWriter;
import com.kdgregory.log4j.aws.internal.shared.MessageQueue;
import com.kdgregory.log4j.aws.internal.shared.RotationMode;
import com.kdgregory.log4j.aws.internal.shared.ThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.WriterFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public abstract class AbstractAppender<WriterConfigType, AppenderStatsType extends AbstractAppenderStatistics, AppenderStatsMXBeanType>
extends AppenderSkeleton {
    private volatile boolean ready = false;
    private volatile boolean closed = false;
    protected ThreadFactory threadFactory;
    protected WriterFactory<WriterConfigType, AppenderStatsType> writerFactory;
    protected AppenderStatsType appenderStats;
    private Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass;
    protected volatile LogWriter writer;
    protected volatile long lastRotationTimestamp;
    protected volatile int lastRotationCount;
    private Object initializationLock = new Object();
    private Object messageQueueLock = new Object();
    protected long batchDelay;
    protected int discardThreshold;
    protected MessageQueue.DiscardAction discardAction;
    protected RotationMode rotationMode;
    protected long rotationInterval;
    protected AtomicInteger sequence;
    protected String clientFactory;
    protected String clientEndpoint;

    public AbstractAppender(ThreadFactory threadFactory, WriterFactory<WriterConfigType, AppenderStatsType> writerFactory, AppenderStatsType appenderStats, Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass) {
        this.threadFactory = threadFactory;
        this.writerFactory = writerFactory;
        this.appenderStats = appenderStats;
        this.appenderStatsMXBeanClass = appenderStatsMXBeanClass;
        this.batchDelay = 2000L;
        this.discardThreshold = 10000;
        this.discardAction = MessageQueue.DiscardAction.oldest;
        this.rotationMode = RotationMode.none;
        this.rotationInterval = -1L;
        this.sequence = new AtomicInteger();
    }

    public void setBatchDelay(long value) {
        this.batchDelay = value;
        if (this.writer != null) {
            this.writer.setBatchDelay(value);
        }
    }

    public long getBatchDelay() {
        return this.batchDelay;
    }

    public void setDiscardThreshold(int value) {
        this.discardThreshold = value;
        if (this.writer != null) {
            this.writer.setDiscardThreshold(value);
        }
    }

    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    public void setDiscardAction(String value) {
        this.discardAction = MessageQueue.DiscardAction.lookup(value);
        if (this.writer != null) {
            this.writer.setDiscardAction(this.discardAction);
        }
    }

    public String getDiscardAction() {
        return this.discardAction.toString();
    }

    public void setRotationMode(String value) {
        this.rotationMode = RotationMode.lookup(value);
    }

    public String getRotationMode() {
        return this.rotationMode.name();
    }

    public void setRotationInterval(long value) {
        this.rotationInterval = value;
    }

    public long getRotationInterval() {
        return this.rotationInterval;
    }

    public void setSequence(int value) {
        this.sequence.set(value);
    }

    public int getSequence() {
        return this.sequence.get();
    }

    public void setClientFactory(String value) {
        this.clientFactory = value;
    }

    public String getClientFactory() {
        return this.clientFactory;
    }

    public void setClientEndpoint(String value) {
        this.clientEndpoint = value;
    }

    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    public AppenderStatsType getAppenderStatistics() {
        return this.appenderStats;
    }

    protected void append(LoggingEvent event) {
        if (this.closed) {
            throw new IllegalStateException("appender is closed");
        }
        if (!this.ready) {
            this.initialize();
        }
        try {
            this.internalAppend(new LogMessage(event, this.getLayout()));
        }
        catch (Exception ex) {
            LogLog.warn((String)"unable to append event", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.stopWriter();
            this.unregisterStatisticsBean();
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotate() {
        Object object = this.initializationLock;
        synchronized (object) {
            this.stopWriter();
            this.sequence.incrementAndGet();
            this.startWriter();
        }
    }

    protected abstract WriterConfigType generateWriterConfig();

    protected abstract boolean isMessageTooLarge(LogMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.startWriter();
            this.registerStatisticsBean();
            this.ready = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                this.writer = this.writerFactory.newLogWriter(this.generateWriterConfig(), this.appenderStats);
                this.threadFactory.startLoggingThread(this.writer, new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable ex) {
                        LogLog.error((String)"unhandled exception in writer", (Throwable)ex);
                        ((AbstractAppenderStatistics)AbstractAppender.this.appenderStats).setLastError(null, ex);
                        AbstractAppender.this.writer = null;
                    }
                });
                if (this.layout.getHeader() != null) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), this.layout.getHeader()));
                }
                this.lastRotationTimestamp = System.currentTimeMillis();
                this.lastRotationCount = 0;
            }
            catch (Exception ex) {
                LogLog.error((String)"exception while initializing writer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                if (this.writer == null) {
                    return;
                }
                if (this.layout.getFooter() != null) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), this.layout.getFooter()));
                }
                this.writer.stop();
            }
            catch (Exception ex) {
                LogLog.error((String)"exception while shutting down writer", (Throwable)ex);
            }
            this.writer = null;
        }
    }

    protected void registerStatisticsBean() {
        JMXManager.getInstance().addAppender(this.getName(), (AbstractAppenderStatistics)this.appenderStats, this.appenderStatsMXBeanClass);
    }

    protected void unregisterStatisticsBean() {
        JMXManager.getInstance().removeAppender(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAppend(LogMessage message) {
        if (message == null) {
            return;
        }
        if (this.isMessageTooLarge(message)) {
            LogLog.warn((String)"attempted to append a message > AWS batch size; ignored");
            return;
        }
        this.rotateIfNeeded(System.currentTimeMillis());
        Object object = this.messageQueueLock;
        synchronized (object) {
            if (this.writer == null) {
                LogLog.warn((String)"appender not properly configured: writer is null");
            } else {
                this.writer.addMessage(message);
                ++this.lastRotationCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateIfNeeded(long now) {
        if (this.shouldRotate(now)) {
            Object object = this.initializationLock;
            synchronized (object) {
                if (this.shouldRotate(now)) {
                    this.rotate();
                }
            }
        }
    }

    private boolean shouldRotate(long now) {
        switch (this.rotationMode) {
            case none: {
                return false;
            }
            case count: {
                return this.rotationInterval > 0L && (long)this.lastRotationCount >= this.rotationInterval;
            }
            case interval: {
                return this.rotationInterval > 0L && now - this.lastRotationTimestamp > this.rotationInterval;
            }
            case hourly: {
                return this.lastRotationTimestamp / 3600000L < now / 3600000L;
            }
            case daily: {
                return this.lastRotationTimestamp / 86400000L < now / 86400000L;
            }
        }
        return false;
    }
}

