/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.kdgregory.log4j.aws.internal.shared.MessageQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractAppenderStatistics {
    private volatile MessageQueue messageQueue;
    private volatile Throwable lastError;
    private volatile String lastErrorMessage;
    private volatile Date lastErrorTimestamp;
    private volatile List<String> lastErrorStacktrace;
    private volatile int messagesSent;

    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void setLastError(String message, Throwable error) {
        this.lastErrorTimestamp = new Date();
        this.lastError = error;
        this.lastErrorMessage = message != null ? message : error.toString();
        this.lastErrorStacktrace = null;
        if (error != null) {
            ArrayList<String> stacktrace = new ArrayList<String>();
            for (StackTraceElement ste : error.getStackTrace()) {
                stacktrace.add(ste.toString());
            }
            this.lastErrorStacktrace = stacktrace;
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Date getLastErrorTimestamp() {
        return this.lastErrorTimestamp;
    }

    public List<String> getLastErrorStacktrace() {
        return this.lastErrorStacktrace;
    }

    public synchronized void updateMessagesSent(int count) {
        this.messagesSent += count;
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public int getMessagesDiscarded() {
        return this.messageQueue.getDroppedMessageCount();
    }
}

