/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.regions.Regions;
import com.kdgregory.log4j.aws.internal.shared.AbstractAppenderStatistics;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.LogWriter;
import com.kdgregory.log4j.aws.internal.shared.MessageQueue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.helpers.LogLog;

public abstract class AbstractLogWriter
implements LogWriter {
    private MessageQueue messageQueue;
    private long batchDelay;
    private Thread dispatchThread;
    private volatile Long shutdownTime;
    private AbstractAppenderStatistics appenderStats;
    private volatile int batchCount;
    private volatile boolean initializationComplete;
    private volatile String factoryMethodUsed;

    public AbstractLogWriter(AbstractAppenderStatistics appenderStats, long batchDelay, int discardThreshold, MessageQueue.DiscardAction discardAction) {
        this.appenderStats = appenderStats;
        this.batchDelay = batchDelay;
        this.messageQueue = new MessageQueue(discardThreshold, discardAction);
        this.appenderStats.setMessageQueue(this.messageQueue);
    }

    public long getBatchDelay() {
        return this.batchDelay;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public boolean isInitializationComplete() {
        return this.initializationComplete;
    }

    public String getClientFactoryUsed() {
        return this.factoryMethodUsed;
    }

    @Override
    public void addMessage(LogMessage message) {
        this.messageQueue.enqueue(message);
    }

    @Override
    public void setBatchDelay(long value) {
        this.batchDelay = value;
    }

    @Override
    public void stop() {
        this.shutdownTime = System.currentTimeMillis() + this.batchDelay;
        if (this.dispatchThread != null) {
            this.dispatchThread.interrupt();
        }
    }

    @Override
    public void setDiscardThreshold(int value) {
        this.messageQueue.setDiscardThreshold(value);
    }

    @Override
    public void setDiscardAction(MessageQueue.DiscardAction value) {
        this.messageQueue.setDiscardAction(value);
    }

    @Override
    public void run() {
        if (!this.initialize()) {
            if (this.appenderStats.getLastError() != null) {
                LogLog.error((String)("initialization failed: " + this.appenderStats.getLastErrorMessage()), (Throwable)this.appenderStats.getLastError());
            } else {
                LogLog.error((String)("initialization failed: " + this.appenderStats.getLastErrorMessage()));
            }
            this.messageQueue.setDiscardThreshold(0);
            this.messageQueue.setDiscardAction(MessageQueue.DiscardAction.oldest);
            return;
        }
        this.dispatchThread = Thread.currentThread();
        this.initializationComplete = true;
        do {
            List<LogMessage> currentBatch;
            if ((currentBatch = this.buildBatch()).size() <= 0) continue;
            ++this.batchCount;
            List<LogMessage> failures = this.processBatch(currentBatch);
            this.requeueMessages(failures);
        } while (this.keepRunning());
    }

    protected abstract void createAWSClient();

    protected abstract boolean ensureDestinationAvailable();

    protected abstract List<LogMessage> processBatch(List<LogMessage> var1);

    protected abstract int effectiveSize(LogMessage var1);

    protected abstract boolean withinServiceLimits(int var1, int var2);

    protected boolean initializationFailure(String message, Exception exception) {
        this.appenderStats.setLastError(message, exception);
        return false;
    }

    protected List<LogMessage> buildBatch() {
        ArrayList<LogMessage> batch = new ArrayList<LogMessage>(512);
        long firstMessageTimeout = this.shutdownTime != null ? this.shutdownTime : Long.MAX_VALUE;
        LogMessage message = this.messageQueue.dequeue(firstMessageTimeout);
        if (message == null) {
            return batch;
        }
        long batchTimeout = System.currentTimeMillis() + this.batchDelay;
        int batchBytes = 0;
        int batchMsgs = 0;
        while (message != null) {
            if (!this.withinServiceLimits(batchBytes += this.effectiveSize(message), ++batchMsgs)) {
                this.messageQueue.requeue(message);
                break;
            }
            batch.add(message);
            message = this.waitForMessage(batchTimeout);
        }
        return batch;
    }

    protected <T> T tryClientFactory(String clientFactoryName, Class<T> expectedClientClass, boolean rethrow) {
        if (clientFactoryName == null || clientFactoryName.isEmpty()) {
            return null;
        }
        try {
            int methodIdx = clientFactoryName.lastIndexOf(46);
            if (methodIdx < 0) {
                throw new RuntimeException("invalid AWS client factory specified: " + clientFactoryName);
            }
            Class<?> factoryKlass = Class.forName(clientFactoryName.substring(0, methodIdx));
            Method factoryMethod = factoryKlass.getDeclaredMethod(clientFactoryName.substring(methodIdx + 1), new Class[0]);
            T client = expectedClientClass.cast(factoryMethod.invoke(null, new Object[0]));
            this.factoryMethodUsed = clientFactoryName;
            LogLog.debug((String)(this.getClass().getSimpleName() + ": created client from factory: " + clientFactoryName));
            return client;
        }
        catch (Exception ex) {
            if (rethrow) {
                throw new RuntimeException("unable to invoke AWS client factory", ex);
            }
            return null;
        }
    }

    protected <T extends AmazonWebServiceClient> T tryConfigureEndpointOrRegion(T client, String endpoint) {
        if (endpoint != null) {
            LogLog.debug((String)(this.getClass().getSimpleName() + ": configuring endpoint: " + endpoint));
            client.setEndpoint(endpoint);
            return client;
        }
        String region = System.getenv("AWS_REGION");
        if (region != null) {
            LogLog.debug((String)(this.getClass().getSimpleName() + ": configuring region: " + region));
            client.configureRegion(Regions.fromName((String)region));
            return client;
        }
        return client;
    }

    private boolean initialize() {
        try {
            this.createAWSClient();
            return this.ensureDestinationAvailable();
        }
        catch (Exception ex) {
            return this.initializationFailure("uncaught exception", ex);
        }
    }

    private boolean keepRunning() {
        return this.shutdownTime == null ? true : this.shutdownTime > System.currentTimeMillis() && this.messageQueue.isEmpty();
    }

    private LogMessage waitForMessage(long waitUntil) {
        long waitTime = waitUntil - System.currentTimeMillis();
        return this.messageQueue.dequeue(waitTime);
    }

    private void requeueMessages(List<LogMessage> messages) {
        Collections.reverse(messages);
        for (LogMessage message : messages) {
            this.messageQueue.requeue(message);
        }
    }
}

