/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.kdgregory.log4j.aws.StatisticsMBean;
import com.kdgregory.log4j.aws.internal.shared.AbstractAppenderStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.helpers.LogLog;

public class JMXManager {
    private static volatile JMXManager singleton = new JMXManager();
    protected Map<StatisticsMBean, List<MBeanServer>> knownServers = new IdentityHashMap<StatisticsMBean, List<MBeanServer>>();
    protected Map<String, AbstractAppenderStatistics> appenderStatsBeans = new HashMap<String, AbstractAppenderStatistics>();
    protected Map<String, Class<?>> appenderStatsBeanTypes = new HashMap();

    public static JMXManager getInstance() {
        return singleton;
    }

    public static void reset(JMXManager newManager) {
        singleton = newManager;
    }

    public synchronized void addStatisticsMBean(StatisticsMBean bean, MBeanServer server, ObjectName name) {
        List<MBeanServer> servers = this.knownServers.get(bean);
        if (servers == null) {
            servers = new ArrayList<MBeanServer>();
            this.knownServers.put(bean, servers);
        }
        servers.add(server);
        for (String appenderName : this.appenderStatsBeans.keySet()) {
            this.registerAppenderBean(appenderName, server);
        }
    }

    public synchronized void removeStatisticsMBean(StatisticsMBean bean) {
        List<MBeanServer> servers = this.knownServers.remove(bean);
        if (servers == null) {
            LogLog.warn((String)"JMXManager: attempt to remove unregistered StatisticsMBean");
            return;
        }
        for (MBeanServer server : servers) {
            for (String appenderName : this.appenderStatsBeans.keySet()) {
                this.unregisterAppenderBean(appenderName, server);
            }
        }
    }

    public synchronized void addAppender(String appenderName, AbstractAppenderStatistics statsBean, Class<?> statsBeanClass) {
        this.appenderStatsBeans.put(appenderName, statsBean);
        this.appenderStatsBeanTypes.put(appenderName, statsBeanClass);
        for (List<MBeanServer> servers : this.knownServers.values()) {
            for (MBeanServer server : servers) {
                this.registerAppenderBean(appenderName, server);
            }
        }
    }

    public synchronized void removeAppender(String appenderName) {
        this.appenderStatsBeans.remove(appenderName);
        this.appenderStatsBeanTypes.remove(appenderName);
        for (List<MBeanServer> servers : this.knownServers.values()) {
            for (MBeanServer server : servers) {
                this.unregisterAppenderBean(appenderName, server);
            }
        }
    }

    protected void registerAppenderBean(String appenderName, MBeanServer mbeanServer) {
        if (appenderName == null) {
            LogLog.error((String)"log4j-aws-appenders: attempted to register null appender");
            return;
        }
        if (mbeanServer == null) {
            LogLog.error((String)"log4j-aws-appenders: attempted to register with null server");
            return;
        }
        AbstractAppenderStatistics statsBean = this.appenderStatsBeans.get(appenderName);
        Class<?> statsBeanClass = this.appenderStatsBeanTypes.get(appenderName);
        if (statsBean == null || statsBeanClass == null) {
            LogLog.error((String)("log4j-aws-appenders: don't know bean or class for appender: " + appenderName));
            return;
        }
        try {
            StandardMBean mbean = new StandardMBean(statsBeanClass.cast(statsBean), statsBeanClass, false);
            mbeanServer.registerMBean(mbean, JMXManager.toObjectName(appenderName));
        }
        catch (Exception ex) {
            LogLog.warn((String)"failed to register appender statistics with JMX", (Throwable)ex);
        }
    }

    protected void unregisterAppenderBean(String appenderName, MBeanServer mbeanServer) {
        try {
            mbeanServer.unregisterMBean(JMXManager.toObjectName(appenderName));
        }
        catch (Exception ex) {
            LogLog.warn((String)"failed to unregister appender statistics with JMX", (Throwable)ex);
        }
    }

    private static ObjectName toObjectName(String appenderName) throws MalformedObjectNameException {
        return new ObjectName("log4j:appender=" + appenderName + ",statistics=statistics");
    }
}

