/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class JsonConverter {
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public JsonConverter() {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String convert(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder(1024);
        this.appendMap(builder, map);
        return builder.toString();
    }

    private void append(StringBuilder builder, String key, Object value) {
        this.appendString(builder, key);
        builder.append(':');
        this.appendValue(builder, value);
    }

    private void appendValue(StringBuilder builder, Object value) {
        if (value instanceof String) {
            this.appendString(builder, (String)value);
        } else if (value instanceof Number) {
            this.appendNumber(builder, (Number)value);
        } else if (value instanceof Boolean) {
            this.appendBoolean(builder, (Boolean)value);
        } else if (value instanceof Date) {
            this.appendDate(builder, (Date)value);
        } else if (value instanceof Object[]) {
            this.appendArray(builder, (Object[])value);
        } else if (value instanceof Collection) {
            this.appendCollection(builder, (Collection)value);
        } else if (value instanceof Map) {
            this.appendMap(builder, (Map)value);
        } else if (value == null) {
            this.appendNull(builder);
        } else {
            this.appendString(builder, String.valueOf(value));
        }
    }

    private void appendString(StringBuilder builder, String value) {
        builder.append("\"");
        int len = value.length();
        for (int ii = 0; ii < len; ++ii) {
            char c = value.charAt(ii);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c >= ' ' && c <= '~') {
                builder.append(c);
                continue;
            }
            if (c >= '\u00a0' && c <= '\ud7ff') {
                builder.append(c);
                continue;
            }
            if (c >= '\ue000') {
                builder.append(c);
                continue;
            }
            if (c == '\u0007') {
                builder.append("\\b");
                continue;
            }
            if (c == '\f') {
                builder.append("\\f");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c != '\t') continue;
            builder.append("\\t");
        }
        builder.append("\"");
    }

    private void appendNumber(StringBuilder builder, Number value) {
        builder.append(value);
    }

    private void appendBoolean(StringBuilder builder, Boolean value) {
        builder.append(value != false ? "true" : "false");
    }

    private void appendDate(StringBuilder builder, Date value) {
        this.appendString(builder, this.dateFormatter.format(value));
    }

    private void appendNull(StringBuilder builder) {
        builder.append("null");
    }

    private void appendArray(StringBuilder builder, Object[] value) {
        builder.append("[");
        for (Object entry : value) {
            this.optAppendComma(builder, '[');
            this.appendValue(builder, entry);
        }
        builder.append("]");
    }

    private void appendCollection(StringBuilder builder, Collection<Object> value) {
        builder.append("[");
        for (Object entry : value) {
            this.optAppendComma(builder, '[');
            this.appendValue(builder, entry);
        }
        builder.append("]");
    }

    private void appendMap(StringBuilder builder, Map<String, Object> map) {
        builder.append("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.optAppendComma(builder, '{');
            this.append(builder, entry.getKey(), entry.getValue());
        }
        builder.append("}");
    }

    private void optAppendComma(StringBuilder builder, char valueInitiator) {
        if (builder.charAt(builder.length() - 1) != valueInitiator) {
            builder.append(",");
        }
    }
}

