/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class LogMessage
implements Comparable<LogMessage> {
    private long timestamp;
    private String message;
    private byte[] messageBytes;

    public LogMessage(long timestamp, String message) {
        this.timestamp = timestamp;
        this.message = message;
        try {
            this.messageBytes = message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException when converting to UTF-8");
        }
    }

    public LogMessage(LoggingEvent event, Layout layout) {
        try {
            StringWriter out = new StringWriter(1024);
            out.write(layout.format(event));
            if (event.getThrowableInformation() != null && layout.ignoresThrowable()) {
                for (String traceline : event.getThrowableStrRep()) {
                    out.write(traceline);
                    out.write(Layout.LINE_SEP);
                }
            }
            out.close();
            this.timestamp = event.getTimeStamp();
            this.message = out.toString();
            this.messageBytes = this.message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException when converting to UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("error creating LogMessage", ex);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int size() {
        return this.messageBytes.length;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getBytes() {
        return this.messageBytes;
    }

    @Override
    public int compareTo(LogMessage that) {
        return this.timestamp < that.timestamp ? -1 : (this.timestamp > that.timestamp ? 1 : 0);
    }
}

