/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageQueue {
    private LinkedBlockingDeque<LogMessage> messageQueue = new LinkedBlockingDeque();
    private AtomicInteger messageCount = new AtomicInteger();
    private AtomicInteger droppedMessageCount = new AtomicInteger();
    private volatile int discardThreshold;
    private volatile DiscardAction discardAction;

    public MessageQueue(int discardThreshold, DiscardAction discardAction) {
        this.discardThreshold = discardThreshold;
        this.discardAction = discardAction;
    }

    public void setDiscardThreshold(int value) {
        this.discardThreshold = value;
    }

    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    public void setDiscardAction(DiscardAction value) {
        this.discardAction = value;
    }

    public DiscardAction getDiscardAction() {
        return this.discardAction;
    }

    public int getDroppedMessageCount() {
        return this.droppedMessageCount.get();
    }

    public boolean isEmpty() {
        return this.messageQueue.peek() == null;
    }

    public void enqueue(LogMessage message) {
        this.messageQueue.addLast(message);
        this.messageCount.incrementAndGet();
        this.applyDiscard();
    }

    public void requeue(LogMessage message) {
        this.messageQueue.addFirst(message);
        this.messageCount.incrementAndGet();
        this.applyDiscard();
    }

    public LogMessage dequeue() {
        LogMessage message = this.messageQueue.poll();
        if (message != null) {
            this.messageCount.decrementAndGet();
        }
        return message;
    }

    public LogMessage dequeue(long waitTime) {
        if (waitTime < 0L) {
            waitTime = 0L;
        }
        try {
            LogMessage message = this.messageQueue.poll(waitTime, TimeUnit.MILLISECONDS);
            if (message != null) {
                this.messageCount.decrementAndGet();
            }
            return message;
        }
        catch (InterruptedException ex) {
            return null;
        }
    }

    public int size() {
        return this.messageCount.get();
    }

    public int queueSize() {
        return this.messageQueue.size();
    }

    public List<LogMessage> toList() {
        return new ArrayList<LogMessage>(this.messageQueue);
    }

    private void applyDiscard() {
        if (this.discardAction == DiscardAction.none) {
            return;
        }
        if (this.size() <= this.discardThreshold) {
            return;
        }
        while (this.size() > this.discardThreshold) {
            LogMessage discarded = this.discardAction == DiscardAction.oldest ? this.messageQueue.pollFirst() : this.messageQueue.pollLast();
            if (discarded == null) continue;
            this.messageCount.decrementAndGet();
            this.droppedMessageCount.incrementAndGet();
        }
    }

    public static enum DiscardAction {
        none,
        oldest,
        newest;


        public static DiscardAction lookup(String value) {
            for (DiscardAction action : DiscardAction.values()) {
                if (!action.toString().equals(value)) continue;
                return action;
            }
            throw new IllegalArgumentException("invalid discardAction: " + value);
        }
    }
}

